"use client";
import Image from "next/image";
import React, { useState } from "react";
import bgimg from "../../../../public/assets/login/bgimg.png";
import image from "../../../../public/assets/new-password/image.png";
import Link from "next/link";
import { useFormik } from "formik";
import * as Yup from "yup";
import { useRouter, useSearchParams } from "next/navigation";
import toast from "react-hot-toast";
import { PostLoginAndSignup } from "../axiosConfig/axiosConfig";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEye, faEyeSlash } from "@fortawesome/free-solid-svg-icons";
const NewPassword = () => {

  const router = useRouter();
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");
  const searchParams = useSearchParams();
  const token = searchParams.get("token");
  const email = searchParams.get("email");
  const [passwordVisible, setPasswordVisible] = useState(false);
  const [confirmVisible, setConfirmVisible] = useState(false);

  const formik = useFormik({
    initialValues: {
      password: "",
      password_confirmation: "",
    },

    validationSchema: Yup.object({
      password: Yup.string()
        .required("Password is required")
        .min(8, "Password is too short - should be 8 chars minimum.")
        .matches(/[a-zA-Z]/, "Password can only contain Latin letters.")
        .matches(
          /[!@#$%^&*(),.?":{}|<>]/,
          "Password must contain at least one special character."
        ),
      password_confirmation: Yup.string()
        .oneOf([Yup.ref("password"), null], "Passwords must match")
        .required("Confirm Password is required"),
    }),

    onSubmit: async (values, { setSubmitting }) => {
      try {
        const requestData = {
          ...values,
          email,
          token,
        };
        const res = await PostLoginAndSignup("/reset-password", requestData);
        router.push("/login");
        toast.success("password reset!", {
          position: "top-center",
        });
      } catch (error) {
        console.error(
          "signUp error:",
          error.response?.data?.errors || error.message
        );
        setError(error.response?.data?.errors || "An error occurred");
      } finally {
        setSubmitting(false);
        setLoading(false);
      }
    },
  });

  return (
    <div className="w-full max-h-[900px] flex justify-between relative">
      <div className="absolute z-10 h-full lg:left-[20%] md:left-[10%] sm:left-[25%] left-[15%] sm:min-w-[383px] w-[300px]">
        <div className="flex flex-col justify-around h-full w-full">
          <div className="flex justify-center">
            <Image
              src="/assets/navbar/logo1.svg"
              alt="logo"
              className="ml-14 w-40 h-40 lg:w-52 lg:h-40 mb-6 md:mb-4"
              width={100}
              height={100}
            />
          </div>
          <form
            className="flex flex-col md:gap-4 gap-4"
            onSubmit={formik.handleSubmit}
          >
            <div className="flex flex-col md:gap-4 gap-3 md:bg-transparent bg-whitegrey p-5 rounded-2xl">
              <div className="flex flex-col gap-3">
                <h1 className="text-black text-3xl font-bold">New Password</h1>
                <p className="text-[#828282] font-normal">
                  Set the new password for your account so you can login and
                  access all features.
                </p>
              </div>
              <div className="flex flex-col gap-2">
                <label>Email:</label>
                <input
                  type="email"
                  className="outline-none py-2 px-3 border border-grey rounded-xl"
                  placeholder=""
                  name="email"
                  value={email}
                  disabled
                />
              </div>
              <div className="relative flex flex-col gap-2">
                <label>New Password:</label>
                <input
                  type={passwordVisible ? "text" : "password"}
                  className={`outline-none py-2 px-3 border border-grey rounded-xl ${
                    formik.touched.password && formik.errors.password
                      ? "border-red-500 "
                      : "border-grey "
                  }`}
                  placeholder="Enter New Password"
                  name="password"
                  value={formik.values.password}
                  onBlur={formik.handleBlur}
                  onChange={formik.handleChange}
                />
                <button
                  type="button"
                  onClick={() => setPasswordVisible(!passwordVisible)}
                  className="absolute text-darkgrey right-3 top-10"
                >
                  {passwordVisible ? (
                    <FontAwesomeIcon icon={faEyeSlash} />
                  ) : (
                    <FontAwesomeIcon icon={faEye} />
                  )}
                </button>
                {formik.touched.password && formik.errors.password && (
                  <p className="text-red-500">{formik.errors.password}</p>
                )}
              </div>
              <div className="relative flex flex-col gap-2">
                <label>Retype New Password:</label>
                <input
                  type={confirmVisible ? "text" : "password"}
                  className={`outline-none py-2 px-3 border border-grey rounded-xl ${
                    formik.touched.password_confirmation &&
                    formik.errors.password_confirmation
                      ? "border-red-500 "
                      : "border-grey "
                  }`}
                  placeholder="Enter Retype New Password"
                  name="password_confirmation"
                  value={formik.values.password_confirmation}
                  onBlur={formik.handleBlur}
                  onChange={formik.handleChange}
                />
                <button
                  type="button"
                  onClick={() => setConfirmVisible(!confirmVisible)}
                  className="absolute text-darkgrey right-3 top-10"
                >
                  {confirmVisible ? (
                    <FontAwesomeIcon icon={faEyeSlash} />
                  ) : (
                    <FontAwesomeIcon icon={faEye} />
                  )}
                </button>
                {formik.touched.password_confirmation &&
                  formik.errors.password_confirmation && (
                    <p className="text-red-500">
                      {formik.errors.password_confirmation}
                    </p>
                  )}
              </div>
              {error && <div className="text-red-500 text-center">{error}</div>}
              <button
                onClick={() => {
                  setLoading(true);
                }}
                type="submit"
                className="bg-golden mt-10 text-white py-2 px-3 rounded-xl"
              >
                {loading ? "Loading..." : "Save Password"}
              </button>
            </div>
          </form>
          <div className="flex flex-col gap-2 mt-8 md:mt-4 lg:mt-12">
            <div className="text-center">
              Login?
              <Link href="/login" className="ml-2 text-golden underline">
                login
              </Link>
            </div>
            <div className="flex flex-col text-center">
              Don't have an account yet?
              <Link href="/sign-up" className="text-golden underline">
                Create an account
              </Link>
            </div>
          </div>
        </div>
      </div>
      <div className=""></div>
      <div className="min-h-screen relative flex justify-end w-full md:w-2/3 lg:w-1/2">
        <Image src={bgimg} alt="bgimg" className="z-0 w-full min-h-full" />
        <div className="absolute hidden md:flex justify-center items-center h-full w-full">
          <Image
            src={image}
            alt="bgimg"
            className="lg:min-h-[360px] min-h-[300px] xl:max-w-[500px] lg:max-w-[300px] md:max-w-[300px]"
          />
        </div>
      </div>
    </div>
  );
};

export default NewPassword;