"use client";
import Image from "next/image";
import React, { useState } from "react";
import bgimg from "../../../../public/assets/login/bgimg.png";
import image from "../../../../public/assets/otp/image.png";
import { useFormik } from "formik";
import * as Yup from "yup";
import toast from "react-hot-toast";
import { useOtpMutation, useOtpResendMutation } from "@/services/Api";
import { useRouter } from "next/navigation";
import { userLogout } from "@/redux/authSlice";
import { useDispatch } from "react-redux";
import Cookies from "js-cookie";

const Otp = () => {
  const [loading, setLoading] = useState(false);
  const [success, setSuccess] = useState("");
  const [error, setError] = useState("");
  const router = useRouter();
  const dispatch = useDispatch();

  const [otp] = useOtpMutation();

  const [otpResend] = useOtpResendMutation();

  const resendOtp = () => {
    otpResend()
      .unwrap()
      .then(() => {
        toast.success("OTP sent Successfully", {
          position: "top-center",
        });
      })
      .catch((error) => {});
  };

  const formik = useFormik({
    initialValues: {
      otp: "",
    },

    validationSchema: Yup.object({
      otp: Yup.string().required("OTP is required").length(6),
    }),

    onSubmit: async (values, { setSubmitting }) => {
      try {
        const res = await otp({ data: values });
        // const token = getState().auth?.token;
        // const res =await fetch(API_END_POINTS.otp, {
        //   headers: {
        //     Authorization: `Bearer ${token}`,
        //     "Content-Type": "application/json",
        //   },
        //   method: "POST",
        //   body: JSON.stringify({data: values}),
        // });

        if (res?.error?.data?.message) {
          toast.error(res.error.data.message, {
            position: "top-center",
          });
        }
        if (res?.data?.message?.includes("OTP has expired")) {
          toast.error("OTP has expired.", {
            position: "top-center",
          });
        } else if (res?.data?.message?.includes("Invalid OTP")) {
          toast.error("Invalid OTP", {
            position: "top-center",
          });
        } else if (
          res?.data?.message?.includes("Email has been verified successfully")
        ) {
          setSuccess("Email has been verified successfully!");
          setError("");
          setLoading(false);

          toast.success("Email has been verified successfully.!", {
            position: "top-center",
          });
          router.push("/dashboard");
        }
      } catch (error) {
        const errorMessage =
          error?.response?.data?.message ||
          error?.message ||
          "An error occurred";

        console.error("Login error:", errorMessage);
        // toast.error("Login error", {
        //   position: "top-center",
        // });
        setError(errorMessage);
      } finally {
        setSubmitting(false);
        setLoading(false);
      }
    },
  });

  const handleLogout = async () => {
    try {
      dispatch(userLogout(null));
      router.push("/login");

      Cookies.remove("role");
      Cookies.remove("authToken");

      localStorage.removeItem("authToken");

      toast.success("Exit Successful", {
        position: "top-center",
      });
      const res = await logoutUser().unwrap();

      if (res) {
        dispatch(userLogout(null));
        router.push("/login");

        Cookies.remove("role");
        Cookies.remove("authToken");
        localStorage.removeItem("authToken");

        toast.success("Exit Successful", {
          position: "top-center",
        });
      }
    } catch (error) {}
  };

  return (
    <div className="w-full max-h-[900px] flex justify-between relative">
      <div className="absolute z-10 h-full lg:left-[20%] md:left-[10%] sm:left-[25%] left-[15%] sm:min-w-[383px] w-[300px]">
        <div className={`flex flex-col justify-around h-full w-full`}>
          <Image
            src="/assets/navbar/logo1.svg"
            alt="logo"
            className="ml-20 w-40 h-40 lg:w-52 lg:h-40 mb-6 md:mb-4"
            width={100}
            height={100}
          />
          <form
            className="flex flex-col md:gap-4 gap-4"
            onSubmit={formik.handleSubmit}
          >
            <div className="flex flex-col md:gap-4 gap-3 md:bg-transparent bg-whitegrey p-5 rounded-2xl">
              <div className="flex flex-col gap-3">
                <h1 className="text-black text-3xl font-bold">Verification</h1>
                <p className="text-[#828282] font-normal">
                  Enter your 6 digits code that you received on your email.
                </p>
              </div>
              <div className="flex flex-col gap-2">
                <input
                  type="number"
                  className={`outline-none py-2 px-3 border rounded-xl ${
                    formik.touched.otp && formik.errors.otp
                      ? "border-red-500 "
                      : "border-grey "
                  }`}
                  placeholder="Enter code"
                  name="otp"
                  value={formik.values.otp}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                />
                {formik.touched.otp && formik.errors.otp ? (
                  <div className="text-red-500">{formik.errors.otp}</div>
                ) : null}
              </div>
              {console.log(error)}
              {error && (
                <div className="text-red-500 text-sm mt-2">{error}</div>
              )}
              <button
                onClick={() => {
                  setLoading(true);
                }}
                type="submit"
                className="bg-golden mt-10 text-white py-2 px-3 rounded-xl"
              >
                {loading ? "Loading..." : "Continue"}
              </button>
            </div>
          </form>
          <div className="flex flex-col gap-2 mt-8 md:mt-4 lg:mt-12">
            <div className="flex flex-col text-center">
              If you didn’t receive a code!
              <span
                className="text-golden underline cursor-pointer"
                onClick={resendOtp}
              >
                Resend
              </span>
            </div>
            <div className="flex flex-col gap-2">
              <div className="flex flex-col text-center">
               If you don’t have access to this email right now
                <span
                  className="text-golden underline cursor-pointer inline-block"
                  onClick={handleLogout}
                >
                  Exit
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div></div>
      <div className="min-h-screen relative flex justify-end w-full md:w-2/3 lg:w-1/2">
        <Image src={bgimg} alt="bgimg" className="z-0 w-full min-h-full" />
        <div className="absolute hidden md:flex justify-center items-center h-full w-full">
          <Image
            src={image}
            alt="bgimg"
            className="lg:min-h-[360px] min-h-[300px] xl:max-w-[500px] lg:max-w-[300px] md:max-w-[300px]"
          />
        </div>
      </div>
    </div>
  );
};

export default Otp;
