import { createSlice } from "@reduxjs/toolkit";
import { persistReducer } from "redux-persist";
import createWebStorage from "redux-persist/lib/storage/createWebStorage";
import { BASE_URL } from "@/services/ApiEndpoints";
import { createAsyncThunk } from "@reduxjs/toolkit";

const createNoopStorage = () => {
  return {
    getItem(_key) {
      return Promise.resolve(null);
    },
    setItem(_key, value) {
      return Promise.resolve(value);
    },
    removeItem(_key) {
      return Promise.resolve();
    },
  };
};

export const registorAPI = createAsyncThunk(
  "registorAPI",
  async (payload, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(BASE_URL + "register-class", {
        method: "POST",
        headers: {
          // "Content-Type": "application/json",
          // Authorization: `Bearer ${token}`,
        },
        body: payload,
      });

      if (response.status === "timeslot_full") throw new Error("Sorry, this class is full for the selected timeslot and plan.");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);
// export const registorAPI = createAsyncThunk(
//   "registorAPI",
//   async (payload, { getState }) => {
//     const token = getState().auth?.token;

//     try {
//       const response = await fetch(BASE_URL + "register-class", {
//         method: "POST",
//         // ❌ remove JSON header
//         headers: {
//           // Authorization: `Bearer ${token}`, // if needed
//         },
//         body: payload, // ✅ send FormData directly
//       });

//       if (!response.ok) {
//         throw new Error("Something went wrong!");
//       }
//       if (response.status === "timeslot_full")
//         throw new Error(
//           "Sorry, this class is full for the selected timeslot and plan."
//         );
//       return await response.json();
//     } catch (error) {
//       throw error;
//     }
//   }
// );

const storage =
  typeof window !== "undefined"
    ? createWebStorage("local")
    : createNoopStorage();

const persistConfig = {
  key: "authSlice",
  version: 1,
  storage,
  blacklist: [],
};

const initialState = {
  isLoggedIn: false,
  token: null,
  userDetail: null,
  user_verified: false,
  loginTime: null,
};

export const authSlice = createSlice({
  name: "auth",
  initialState,
  reducers: {
    loggedIn: (state, data) => {
      state.isLoggedIn = true;
      state.token = data.payload.token;
      state.userDetail = data.payload.user;
      state.user_verified = data.payload.user_verified;
      state.loginTime = Date.now();
    },

    userLogout: (state) => {
      state.isLoggedIn = false;
      state.token = null;
      state.userDetail = null;
      state.user_verified = false;
      state.loginTime = null;
    },

    updateUserProfile: (state, data) => {
      state.userDetail = { ...state.userDetail, ...data.payload };
    },
  },
});

export const { loggedIn, userLogout, updateUserProfile } = authSlice.actions;

export default persistReducer(persistConfig, authSlice.reducer);
