import React, { useRef, useState, useEffect } from "react";
import Notifications from "../../notifications/Notifications";
import ProfileImage from "../../../../../public/assets/dashboard/profile.png";
import Image from "next/image";
import Link from "next/link";
import { useLogoutUserMutation } from "@/services/Api";
import { userLogout } from "@/redux/authSlice";
import { useRouter } from "next/navigation";
import Cookies from "js-cookie";
import toast from "react-hot-toast";
import {
  useGetUserDetailQuery,
} from "@/services/Api";
import { useDispatch, useSelector } from "react-redux";

const Header = ({ title }) => {
  const [userDetails, setUserDetails] = useState(null);

  const getDetails = useSelector((state) => state.auth.userDetail);
  const { data: getUserDetail, refetch: getUserDetailRefetch } =
      useGetUserDetailQuery();
  const [showDropdown, setShowDropdown] = useState(false);
  const dropdownRef = useRef(null);
  
  useEffect(() => {
      setUserDetails(getUserDetail?.user);
    }, [getUserDetail]);

  useEffect(() => {
      getUserDetailRefetch();
    }, []);

  useEffect(() => {
    const handleClickOutside = (event) => {
      if (
        dropdownRef.current &&
        !dropdownRef.current.contains(event.target) &&
        event.target.textContent !== "Profile" &&
        event.target.textContent !== "Logout"
      ) {
        setShowDropdown(false);
      }
    };
    document.addEventListener("mousedown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, []);

  const [logoutUser] = useLogoutUserMutation();
  const dispatch = useDispatch();
  const router = useRouter();

  const handleLogout = () => {
    dispatch(userLogout(null));
    router.push("/");
    Cookies.remove("role");
    Cookies.remove("authToken");
    localStorage.clear();
    logoutUser()
      .unwrap()
      .then(() => {
        dispatch(userLogout(null));
        router.push("/");
        Cookies.remove("role");
        Cookies.remove("authToken");
        localStorage.clear();
        toast.success("Logout Successful", {
          position: "top-center",
        });
      })
      .catch((error) => {
        console.log(error);
      });
  };

  return (
    <div className="flex items-center justify-between pb-2 pt-3">
      <h1 className=" text-[31px] font-bold">{title}</h1>
      <div className="flex items-center align-center gap-5">
        <div className="flex items-center gap-2 mr-3">
          <Notifications />
        </div>
        <div className="flex items-center gap-2">
          <div className="flex flex-col">
            <p className="text-[16px] font-bold text-golden">
              {getDetails?.name}
            </p>
            <p className="text-[12px] text-darkgrey mt-[-5px]">
              {getDetails?.role?.name}
            </p>
          </div>
          <div className="relative">
            <button
              onClick={() => setShowDropdown(!showDropdown)}
              ref={dropdownRef}
            >
              <div className="w-[45px] h-[45px]">
                {/* <img
                  src={getDetails?.profile ? getDetails.profile : ProfileImage}
                  alt="profile"
                  className="rounded-full cursor-pointer w-full h-full"
                /> */}
                {/* {console.log(userDetails?.media.length > 0 ? userDetails?.media?.[0]?.original_url : ProfileImage)} */}
                <img
                  src={userDetails?.media.length > 0 ? userDetails?.media?.[0]?.original_url : ProfileImage.src}
                  alt="profile"
                  className="bg-gray-500 rounded-full h-full w-full"
                />
                {/* <Image 
                  src={userDetails?.media.length > 0 ? userDetails?.media?.[0]?.original_url : ProfileImage.src}
                  alt="profile"
                  width={100}
                  height={100}
                  className="bg-gray-500 rounded-full h-full w-full"
                  /> */}
              </div>
            </button>
            {showDropdown && (
              <div className="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2">
                <Link
                  href="/profile"
                  className="block px-4 py-2 text-sm text-gray-700 hover:bg-golden hover:text-white"
                >
                  Profile
                </Link>
                <button
                  onClick={handleLogout}
                  className="block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-golden hover:text-white"
                >
                  Logout
                </button>
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  );
};

export default Header;
