"use client";
import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faMagnifyingGlass } from "@fortawesome/free-solid-svg-icons";
import { useGetBlogsQuery } from "@/services/Api";
import { useRouter } from "next/navigation";

const Blog = () => {

  const [showMore, setShowMore] = useState(false);
  const router = useRouter();

  const {
    data: getBlogs,
    refetch: getBlogsRefetch,
    isLoading: getBlogsIsLoading,
  } = useGetBlogsQuery();

  const handleNavigate = (id) => {
    router.push(`/blog-detail?id=${id}`);
  };

  useEffect(() => {
    getBlogsRefetch();
  }, []);

  const blogsToShow = showMore ? getBlogs?.blogs : getBlogs?.blogs?.slice(0, 12);

  return (
    <div>
      <div className="relative">
        <img
          src="/assets/home/homeCard.png"
          alt="Home-Card"
          className="w-full max-h-[500px] bg-cover"
        />
        <div className="absolute top-0 left-0 h-full w-full flex justify-center items-center bg-black opacity-80">
          <div className="flex flex-col gap-4">
            <p className="text-white font-medium text-3xl text-center">
              Agent Ambition Academy Blog
            </p>
            <p className="text-white font-normal text-lg text-center">
              What are you looking for?
            </p>
            <div className="flex h-11 justify-center">
              <input
                type="text"
                className="bg-white text-black h-full w-96 outline-none px-3 rounded-l-lg"
                placeholder="Type in your search term here"
              />
              <p className="flex justify-center items-center h-full bg-golden w-14 rounded-r-lg">
                <FontAwesomeIcon
                  icon={faMagnifyingGlass}
                  className="text-white"
                />
              </p>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-7xl mx-auto bg-white mt-3 p-4 pb-10 rounded-xl">
        {blogsToShow?.length ?
          <div className="py-6">
            <p className=" max-w-m text-[20px] font-bold">Recent Blogs</p>
          </div>
          : null}

        <div className="grid lg:grid-cols-4 place-items-center md:grid-cols-3 sm:grid-cols-2 grid-cols-1 min-h-[314px] gap-5">
          {blogsToShow?.length ? blogsToShow?.map((data, index) => {
            return (
              <div key={index} className="w-full border rounded-md shadow-md cursor-pointer" onClick={() => handleNavigate(data?.id)}>
                <div>
                  <img
                    src={data?.media[0]?.original_url}
                    alt=""
                    className="rounded-md h-48 object-contain"
                  />
                  <div className="p-4">
                    <p className="text-sm font-normal text-[#555555] capitalize">
                      {data?.category?.slug}
                    </p>
                    <p className="text-[#363636] text-xl font-bold capitalize">
                      {data?.title}
                    </p>
                  </div>
                </div>
              </div>
            )
          }) : <>
            {getBlogsIsLoading ?
              <p className="mt-1 text-gray-600 text-center">
                Loading...
              </p>
              :
              <p className="mt-1 text-gray-600 text-center">
                No blogs found...
              </p>
            }
          </>}
        </div>

        {blogsToShow?.length > 12 ?
          <div className="text-center my-8">
            <button
              className="bg-golden rounded-md font-medium text-base text-white py-2 px-4"
              onClick={() => setShowMore(!showMore)}
            >
              {showMore ? "Show Less" : "View More Blog Posts"}
            </button>
          </div>
          : null}
      </div>
    </div>
  );
};

export default Blog;