"use client";
import React from "react";

export default function CertificateComponent({
  courseTitle,
  studentName,
  completionDate,
}) {
  return (
    <div
      style={{
        width: "100%",
        height: "100%",
        background: "#fff",
        // margin: "40px auto",
        padding: "40px",
        position: "relative",
        boxShadow: "0 0 20px rgba(0,0,0,0.5)",
        textAlign: "center",
        overflow: "hidden",
        fontFamily: "'Lora', serif",
      }}
    >
      {/* Google Fonts */}
      <link
        href="https://fonts.googleapis.com/css2?family=Lora&family=Pinyon+Script&display=swap"
        rel="stylesheet"
      />
      <link
        href="https://fonts.googleapis.com/css2?family=Anek+Kannada:wght@100..800&display=swap"
        rel="stylesheet"
      />

      {/* LEFT SIDE */}
      <div
        style={{
          position: "absolute",
          top: "-50px",
          left: "-217px",
          width: "203px",
          height: "120%",
          background: "#3f4142",
          transform: "rotate(-14deg)",
          transformOrigin: "top left",
          zIndex: 1,
          boxShadow: "8px 0 20.3px rgba(0, 0, 0, 0.6)",
        }}
      ></div>

      <div
        style={{
          position: "absolute",
          top: "-53px",
          left: "3px",
          width: "193px",
          height: "110%",
          background:
            "repeating-linear-gradient(90deg, rgba(112, 105, 85, 0.6) 0px, rgba(112, 105, 85, 0.6) 1px, transparent 2px, transparent 5px), linear-gradient(67.87deg, #B0925B 50.93%, #BA9F57 51.62%, #7E4E38 80.27%, #AF915B 89.65%, #A9905C 100%)",
          transform: "rotate(14deg)",
          transformOrigin: "top left",
          zIndex: 2,
          boxShadow: "8px 0 20.3px rgba(0, 0, 0, 0.6)",
        }}
      ></div>

      <div
        style={{
          position: "absolute",
          bottom: "-50px",
          left: "-66px",
          width: "180px",
          height: "70%",
          background: "#3f4142",
          transform: "rotate(-15deg)",
          transformOrigin: "bottom left",
          zIndex: 3,
          boxShadow: "4px 0 22px rgba(255, 255, 255, 0.4)",
        }}
      ></div>

      {/* RIGHT SIDE */}
      <div
        style={{
          position: "absolute",
          top: "762px",
          right: "192px",
          width: "164px",
          height: "120%",
          background:
            "repeating-linear-gradient(90deg, rgba(112, 105, 85, 0.6) 0px, rgba(112, 105, 85, 0.6) 1px, transparent 2px, transparent 6px), linear-gradient(67.87deg, #B0925B 60.93%, #BA9F57 51.62%, #7E4E38 80.27%, #AF915B 96.65%, #A9905C 100%)",
          transform: "rotate(194deg)",
          transformOrigin: "top right",
          boxShadow: "8px 0 20.3px rgba(0, 0, 0, 0.4)",
          zIndex: 1,
        }}
      ></div>

      <div
        style={{
          position: "absolute",
          top: "-59px",
          right: "-22px",
          width: "220px",
          height: "120%",
          background: "#3f4142",
          transform: "rotate(-14deg)",
          transformOrigin: "top right",
          boxShadow: "-8px 0 15px rgba(0, 0, 0, 0.4)",
          zIndex: 2,
        }}
      ></div>

      <div
        style={{
          position: "absolute",
          top: "762px",
          right: "94px",
          width: "164px",
          height: "120%",
          background:
            "repeating-linear-gradient(90deg, rgba(112, 105, 85, 0.6) 0px, rgba(112, 105, 85, 0.6) 1px, transparent 2px, transparent 6px), linear-gradient(67.87deg, #B0925B 60.93%, #BA9F57 51.62%, #7E4E38 80.27%, #AF915B 96.65%, #A9905C 100%)",
          transform: "rotate(194.3deg)",
          transformOrigin: "top right",
          zIndex: 2,
        }}
      ></div>

      {/* Certificate Content */}
      <div
        style={{
          maxWidth: "730px",
          position: "relative",
          height: "100%",
          margin: "0 auto",
          zIndex: 5,
        }}
      >
        <div
          style={{
            marginBottom: "10px",
            margin: "auto",
            width: 205, // number = 205px
            height: 110, // number = 110px
            overflow: "hidden",
          }}
        >
          <img
            src="/certificate_logo.png"
            alt=""
            style={{ objectFit: "contain", width: "100%", height: "100%" }}
          />
        </div>

        <div style={{ fontSize: "60px", color: "#b8860b", margin: "0" }}>
          CERTIFICATE
        </div>
        <div
          style={{
            marginTop: "-3px",
            fontSize: "20.5px",
            letterSpacing: "2.1px",
            marginBottom: "20px",
          }}
        >
          OF SATISFACTORY COMPLETION
        </div>

        <div
          style={{
            fontSize: "20px",
            color: "#b8860b",
            marginBottom: "5px",
            textTransform: "uppercase",
          }}
        >
          {courseTitle}
        </div>

        <div
          style={{
            fontSize: "27px",
            marginBottom: "0",
            textTransform: "uppercase",
            letterSpacing: "2px",
          }}
        >
          THIS IS TO CERTIFY THAT
        </div>

        <div
          style={{
            fontSize: "88px",
            fontFamily: "'Pinyon Script', cursive",
            color: "#b8860b",
            marginTop: "-30px",
            borderBottom: "1px solid #b8860b",
            display: "inline-block",
            padding: "0 20px",
            lineHeight: "150px",
          }}
        >
          {studentName || "Name Here"}
        </div>

        <div
          style={{
            letterSpacing: "0px",
            fontSize: "17.1px",
            lineHeight: 1,
            margin: "10.7px 60px",
            fontFamily: "'Anek Kannada', sans-serif",
          }}
        >
          Has satisfactorily completed a course of study in real estate approved
          by the Secretary of State in accordance with the provisions of Chapter
          868 of the Laws of 1977 and the attendance of the student was in
          compliance with the law.
        </div>

        <div
          style={{
            fontSize: "20.2px",
            marginTop: "20px",
            fontFamily: "'Anek Kannada', sans-serif",
            lineHeight: 1.3,
          }}
        >
          COURSE APPROVAL CODE NUMBER IS <strong>D01090</strong>
          <br />
          THE COURSE WAS COMPLETED ON{" "}
          <strong>{completionDate || "DD.MM.YYYY"}</strong>
        </div>

        <div
          style={{
            position: "absolute",
            bottom: "0px",
            width: "68%",
            display: "flex",
            justifyContent: "space-between",
            fontSize: "17px",
            fontFamily: "'Anek Kannada', sans-serif",
            left: "50%",
            transform: "translateX(-50%)",
          }}
        >
          <div
            style={{
              borderTop: "1px solid #000",
              paddingTop: "5px",
              width: "200px",
              textAlign: "center",
            }}
          >
            FRONT AUTHORIZED NAME
          </div>
          <div
            style={{
              borderTop: "1px solid #000",
              paddingTop: "5px",
              width: "200px",
              textAlign: "center",
            }}
          >
            AUTHORIZED SIGNATURE
          </div>
        </div>
      </div>
    </div>
  );
}
