// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var _a;
import * as Core from "./core.mjs";
import * as Errors from "./error.mjs";
import * as Uploads from "./uploads.mjs";
import * as qs from 'qs';
import * as Pagination from '@mux/mux-node/pagination';
import * as API from '@mux/mux-node/resources/index';
/** API Client for interfacing with the Mux API. */
export class Mux extends Core.APIClient {
    /**
     * API Client for interfacing with the Mux API.
     *
     * @param {string | undefined} [opts.tokenId=process.env['MUX_TOKEN_ID'] ?? undefined]
     * @param {string | undefined} [opts.tokenSecret=process.env['MUX_TOKEN_SECRET'] ?? undefined]
     * @param {string | null | undefined} [opts.webhookSecret=process.env['MUX_WEBHOOK_SECRET'] ?? null]
     * @param {string | null | undefined} [opts.jwtSigningKey=process.env['MUX_SIGNING_KEY'] ?? null]
     * @param {string | null | undefined} [opts.jwtPrivateKey=process.env['MUX_PRIVATE_KEY'] ?? null]
     * @param {string} [opts.baseURL=process.env['MUX_BASE_URL'] ?? https://api.mux.com] - Override the default base URL for the API.
     * @param {number} [opts.timeout=1 minute] - The maximum amount of time (in milliseconds) the client will wait for a response before timing out.
     * @param {number} [opts.httpAgent] - An HTTP agent used to manage HTTP(s) connections.
     * @param {Core.Fetch} [opts.fetch] - Specify a custom `fetch` function implementation.
     * @param {number} [opts.maxRetries=2] - The maximum number of times the client will retry a request.
     * @param {Core.Headers} opts.defaultHeaders - Default headers to include with every request to the API.
     * @param {Core.DefaultQuery} opts.defaultQuery - Default query parameters to include with every request to the API.
     */
    constructor({ baseURL = Core.readEnv('MUX_BASE_URL'), tokenId = Core.readEnv('MUX_TOKEN_ID'), tokenSecret = Core.readEnv('MUX_TOKEN_SECRET'), webhookSecret = Core.readEnv('MUX_WEBHOOK_SECRET') ?? null, jwtSigningKey = Core.readEnv('MUX_SIGNING_KEY') ?? null, jwtPrivateKey = Core.readEnv('MUX_PRIVATE_KEY') ?? null, ...opts } = {}) {
        if (tokenId === undefined) {
            throw new Errors.MuxError("The MUX_TOKEN_ID environment variable is missing or empty; either provide it, or instantiate the Mux client with an tokenId option, like new Mux({ tokenId: 'my token id' }).");
        }
        if (tokenSecret === undefined) {
            throw new Errors.MuxError("The MUX_TOKEN_SECRET environment variable is missing or empty; either provide it, or instantiate the Mux client with an tokenSecret option, like new Mux({ tokenSecret: 'my secret' }).");
        }
        const options = {
            tokenId,
            tokenSecret,
            webhookSecret,
            jwtSigningKey,
            jwtPrivateKey,
            ...opts,
            baseURL: baseURL || `https://api.mux.com`,
        };
        super({
            baseURL: options.baseURL,
            timeout: options.timeout ?? 60000 /* 1 minute */,
            httpAgent: options.httpAgent,
            maxRetries: options.maxRetries,
            fetch: options.fetch,
        });
        this.video = new API.Video(this);
        this.data = new API.Data(this);
        this.system = new API.System(this);
        this.webhooks = new API.Webhooks(this);
        this.jwt = new API.Jwt(this);
        this._options = options;
        this.tokenId = tokenId;
        this.tokenSecret = tokenSecret;
        this.webhookSecret = webhookSecret;
        this.jwtSigningKey = jwtSigningKey;
        this.jwtPrivateKey = jwtPrivateKey;
    }
    defaultQuery() {
        return this._options.defaultQuery;
    }
    defaultHeaders(opts) {
        return {
            ...super.defaultHeaders(opts),
            ...this._options.defaultHeaders,
        };
    }
    authHeaders(opts) {
        if (!this.tokenId) {
            return {};
        }
        if (!this.tokenSecret) {
            return {};
        }
        const credentials = `${this.tokenId}:${this.tokenSecret}`;
        const Authorization = `Basic ${Core.toBase64(credentials)}`;
        return { Authorization };
    }
    stringifyQuery(query) {
        return qs.stringify(query, { arrayFormat: 'brackets' });
    }
}
_a = Mux;
Mux.Mux = _a;
Mux.MuxError = Errors.MuxError;
Mux.APIError = Errors.APIError;
Mux.APIConnectionError = Errors.APIConnectionError;
Mux.APIConnectionTimeoutError = Errors.APIConnectionTimeoutError;
Mux.APIUserAbortError = Errors.APIUserAbortError;
Mux.NotFoundError = Errors.NotFoundError;
Mux.ConflictError = Errors.ConflictError;
Mux.RateLimitError = Errors.RateLimitError;
Mux.BadRequestError = Errors.BadRequestError;
Mux.AuthenticationError = Errors.AuthenticationError;
Mux.InternalServerError = Errors.InternalServerError;
Mux.PermissionDeniedError = Errors.PermissionDeniedError;
Mux.UnprocessableEntityError = Errors.UnprocessableEntityError;
Mux.toFile = Uploads.toFile;
Mux.fileFromPath = Uploads.fileFromPath;
export const { MuxError, APIError, APIConnectionError, APIConnectionTimeoutError, APIUserAbortError, NotFoundError, ConflictError, RateLimitError, BadRequestError, AuthenticationError, InternalServerError, PermissionDeniedError, UnprocessableEntityError, } = Errors;
export var toFile = Uploads.toFile;
export var fileFromPath = Uploads.fileFromPath;
(function (Mux) {
    Mux.PageWithTotal = Pagination.PageWithTotal;
    Mux.BasePage = Pagination.BasePage;
    Mux.Video = API.Video;
    Mux.Data = API.Data;
    Mux.System = API.System;
    Mux.Webhooks = API.Webhooks;
    Mux.Jwt = API.Jwt;
})(Mux || (Mux = {}));
export default Mux;
//# sourceMappingURL=index.mjs.map