import { AbstractPage, Response, APIClient, FinalRequestOptions, PageInfo } from "./core.js";
export interface PageWithTotalResponse<Item> {
    data: Array<Item>;
    total_row_count: number;
    timeframe: Array<number>;
    /**
     * Number of assets returned in this response. Default value is 100.
     */
    limit: number;
}
export interface PageWithTotalParams {
    page?: number;
    limit?: number;
}
export declare class PageWithTotal<Item> extends AbstractPage<Item> implements PageWithTotalResponse<Item> {
    data: Array<Item>;
    total_row_count: number;
    timeframe: Array<number>;
    /**
     * Number of assets returned in this response. Default value is 100.
     */
    limit: number;
    constructor(client: APIClient, response: Response, body: PageWithTotalResponse<Item>, options: FinalRequestOptions);
    getPaginatedItems(): Item[];
    nextPageParams(): Partial<PageWithTotalParams> | null;
    nextPageInfo(): PageInfo | null;
}
export interface BasePageResponse<Item> {
    data: Array<Item>;
}
export interface BasePageParams {
    page?: number;
    limit?: number;
}
export declare class BasePage<Item> extends AbstractPage<Item> implements BasePageResponse<Item> {
    data: Array<Item>;
    constructor(client: APIClient, response: Response, body: BasePageResponse<Item>, options: FinalRequestOptions);
    getPaginatedItems(): Item[];
    nextPageParams(): Partial<BasePageParams> | null;
    nextPageInfo(): PageInfo | null;
}
//# sourceMappingURL=pagination.d.ts.map