"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasePage = exports.PageWithTotal = void 0;
const core_1 = require("./core.js");
class PageWithTotal extends core_1.AbstractPage {
    constructor(client, response, body, options) {
        super(client, response, body, options);
        this.data = body.data || [];
        this.total_row_count = body.total_row_count || 0;
        this.timeframe = body.timeframe || [];
        this.limit = body.limit || 0;
    }
    getPaginatedItems() {
        return this.data ?? [];
    }
    // @deprecated Please use `nextPageInfo()` instead
    nextPageParams() {
        const info = this.nextPageInfo();
        if (!info)
            return null;
        if ('params' in info)
            return info.params;
        const params = Object.fromEntries(info.url.searchParams);
        if (!Object.keys(params).length)
            return null;
        return params;
    }
    nextPageInfo() {
        const query = this.options.query;
        const currentPage = query?.page ?? 1;
        return { params: { page: currentPage + 1 } };
    }
}
exports.PageWithTotal = PageWithTotal;
class BasePage extends core_1.AbstractPage {
    constructor(client, response, body, options) {
        super(client, response, body, options);
        this.data = body.data || [];
    }
    getPaginatedItems() {
        return this.data ?? [];
    }
    // @deprecated Please use `nextPageInfo()` instead
    nextPageParams() {
        const info = this.nextPageInfo();
        if (!info)
            return null;
        if ('params' in info)
            return info.params;
        const params = Object.fromEntries(info.url.searchParams);
        if (!Object.keys(params).length)
            return null;
        return params;
    }
    nextPageInfo() {
        const query = this.options.query;
        const currentPage = query?.page ?? 1;
        return { params: { page: currentPage + 1 } };
    }
}
exports.BasePage = BasePage;
//# sourceMappingURL=pagination.js.map