import { APIResource } from '@mux/mux-node/resource';
import { type MuxJWTSignOptions, TypeClaim, DataTypeClaim } from '@mux/mux-node/util/jwt-types';
export declare class Jwt extends APIResource {
    /**
     * Creates a new token to be used with a signed Playback ID
     */
    signPlaybackId(playbackId: string, config?: MuxJWTSignOptions<keyof typeof TypeClaim>): Promise<string>;
    /**
     * Creates a new token for a license for playing back DRM'd video content
     */
    signDrmLicense(playbackId: string, config?: MuxJWTSignOptions<keyof typeof TypeClaim>): Promise<string>;
    /**
     * Creates a new token to be used with a space
     * @deprecated Mux Real-Time Video (spaces) has been shut down. This function will be removed in the next major version.
     */
    signSpaceId(spaceId: string, config?: MuxJWTSignOptions<never>): Promise<string>;
    /**
     * Creates a new token to be used with a signed statistics request
     */
    signViewerCounts(id: string, config?: MuxJWTSignOptions<keyof typeof DataTypeClaim>): Promise<string>;
}
//# sourceMappingURL=jwt.d.ts.map