"use strict";
// File generated from our OpenAPI spec by Stainless.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jwt = void 0;
const resource_1 = require("@mux/mux-node/resource");
const jwt = __importStar(require("@mux/mux-node/_shims/auto/jwt"));
const jwt_types_1 = require("@mux/mux-node/util/jwt-types");
class Jwt extends resource_1.APIResource {
    /**
     * Creates a new token to be used with a signed Playback ID
     */
    async signPlaybackId(playbackId, config = {}) {
        const claim = jwt_types_1.TypeClaim[config.type ?? 'video'];
        if (!claim) {
            throw new Error(`Invalid signature type: ${config.type}; Expected one of ${Object.keys(jwt_types_1.TypeClaim)}`);
        }
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: playbackId,
            audience: claim,
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
    /**
     * Creates a new token for a license for playing back DRM'd video content
     */
    async signDrmLicense(playbackId, config = {}) {
        const claim = jwt_types_1.TypeClaim[config.type ?? 'drm_license'];
        if (!claim) {
            throw new Error(`Invalid signature type: ${config.type}; Expected one of ${Object.keys(jwt_types_1.TypeClaim)}`);
        }
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: playbackId,
            audience: claim,
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
    /**
     * Creates a new token to be used with a space
     * @deprecated Mux Real-Time Video (spaces) has been shut down. This function will be removed in the next major version.
     */
    async signSpaceId(spaceId, config = {}) {
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: spaceId,
            audience: 'rt',
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
    /**
     * Creates a new token to be used with a signed statistics request
     */
    async signViewerCounts(id, config = {}) {
        const claim = jwt_types_1.DataTypeClaim[config.type ?? 'video'];
        if (!claim) {
            throw new Error(`Invalid signature type: ${config.type}; Expected one of ${Object.keys(jwt_types_1.DataTypeClaim)}`);
        }
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: id,
            audience: claim,
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
}
exports.Jwt = Jwt;
//# sourceMappingURL=jwt.js.map