// File generated from our OpenAPI spec by Stainless.
import { APIResource } from '@mux/mux-node/resource';
import * as jwt from '@mux/mux-node/_shims/auto/jwt';
import { TypeClaim, DataTypeClaim, } from '@mux/mux-node/util/jwt-types';
export class Jwt extends APIResource {
    /**
     * Creates a new token to be used with a signed Playback ID
     */
    async signPlaybackId(playbackId, config = {}) {
        const claim = TypeClaim[config.type ?? 'video'];
        if (!claim) {
            throw new Error(`Invalid signature type: ${config.type}; Expected one of ${Object.keys(TypeClaim)}`);
        }
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: playbackId,
            audience: claim,
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
    /**
     * Creates a new token for a license for playing back DRM'd video content
     */
    async signDrmLicense(playbackId, config = {}) {
        const claim = TypeClaim[config.type ?? 'drm_license'];
        if (!claim) {
            throw new Error(`Invalid signature type: ${config.type}; Expected one of ${Object.keys(TypeClaim)}`);
        }
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: playbackId,
            audience: claim,
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
    /**
     * Creates a new token to be used with a space
     * @deprecated Mux Real-Time Video (spaces) has been shut down. This function will be removed in the next major version.
     */
    async signSpaceId(spaceId, config = {}) {
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: spaceId,
            audience: 'rt',
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
    /**
     * Creates a new token to be used with a signed statistics request
     */
    async signViewerCounts(id, config = {}) {
        const claim = DataTypeClaim[config.type ?? 'video'];
        if (!claim) {
            throw new Error(`Invalid signature type: ${config.type}; Expected one of ${Object.keys(DataTypeClaim)}`);
        }
        const tokenOptions = {
            keyid: jwt.getSigningKey(this._client, config),
            subject: id,
            audience: claim,
            expiresIn: config.expiration ?? '7d',
            noTimestamp: true,
            algorithm: 'RS256',
        };
        return jwt.sign(config.params ?? {}, await jwt.getPrivateKey(this._client, config), tokenOptions);
    }
}
//# sourceMappingURL=jwt.mjs.map