export type MediaUIEvents = {
    MEDIA_PLAY_REQUEST: 'mediaplayrequest';
    MEDIA_PAUSE_REQUEST: 'mediapauserequest';
    MEDIA_MUTE_REQUEST: 'mediamuterequest';
    MEDIA_UNMUTE_REQUEST: 'mediaunmuterequest';
    MEDIA_VOLUME_REQUEST: 'mediavolumerequest';
    MEDIA_SEEK_REQUEST: 'mediaseekrequest';
    MEDIA_AIRPLAY_REQUEST: 'mediaairplayrequest';
    MEDIA_ENTER_FULLSCREEN_REQUEST: 'mediaenterfullscreenrequest';
    MEDIA_EXIT_FULLSCREEN_REQUEST: 'mediaexitfullscreenrequest';
    MEDIA_PREVIEW_REQUEST: 'mediapreviewrequest';
    MEDIA_ENTER_PIP_REQUEST: 'mediaenterpiprequest';
    MEDIA_EXIT_PIP_REQUEST: 'mediaexitpiprequest';
    MEDIA_ENTER_CAST_REQUEST: 'mediaentercastrequest';
    MEDIA_EXIT_CAST_REQUEST: 'mediaexitcastrequest';
    MEDIA_SHOW_TEXT_TRACKS_REQUEST: 'mediashowtexttracksrequest';
    MEDIA_HIDE_TEXT_TRACKS_REQUEST: 'mediahidetexttracksrequest';
    MEDIA_SHOW_SUBTITLES_REQUEST: 'mediashowsubtitlesrequest';
    MEDIA_DISABLE_SUBTITLES_REQUEST: 'mediadisablesubtitlesrequest';
    MEDIA_TOGGLE_SUBTITLES_REQUEST: 'mediatogglesubtitlesrequest';
    MEDIA_PLAYBACK_RATE_REQUEST: 'mediaplaybackraterequest';
    MEDIA_RENDITION_REQUEST: 'mediarenditionrequest';
    MEDIA_AUDIO_TRACK_REQUEST: 'mediaaudiotrackrequest';
    MEDIA_SEEK_TO_LIVE_REQUEST: 'mediaseektoliverequest';
    REGISTER_MEDIA_STATE_RECEIVER: 'registermediastatereceiver';
    UNREGISTER_MEDIA_STATE_RECEIVER: 'unregistermediastatereceiver';
};
/**
 * @typedef {{
 *   MEDIA_PLAY_REQUEST: 'mediaplayrequest',
 *   MEDIA_PAUSE_REQUEST: 'mediapauserequest',
 *   MEDIA_MUTE_REQUEST: 'mediamuterequest',
 *   MEDIA_UNMUTE_REQUEST: 'mediaunmuterequest',
 *   MEDIA_VOLUME_REQUEST: 'mediavolumerequest',
 *   MEDIA_SEEK_REQUEST: 'mediaseekrequest',
 *   MEDIA_AIRPLAY_REQUEST: 'mediaairplayrequest',
 *   MEDIA_ENTER_FULLSCREEN_REQUEST: 'mediaenterfullscreenrequest',
 *   MEDIA_EXIT_FULLSCREEN_REQUEST: 'mediaexitfullscreenrequest',
 *   MEDIA_PREVIEW_REQUEST: 'mediapreviewrequest',
 *   MEDIA_ENTER_PIP_REQUEST: 'mediaenterpiprequest',
 *   MEDIA_EXIT_PIP_REQUEST: 'mediaexitpiprequest',
 *   MEDIA_ENTER_CAST_REQUEST: 'mediaentercastrequest',
 *   MEDIA_EXIT_CAST_REQUEST: 'mediaexitcastrequest',
 *   MEDIA_SHOW_TEXT_TRACKS_REQUEST: 'mediashowtexttracksrequest',
 *   MEDIA_HIDE_TEXT_TRACKS_REQUEST: 'mediahidetexttracksrequest',
 *   MEDIA_SHOW_SUBTITLES_REQUEST: 'mediashowsubtitlesrequest',
 *   MEDIA_DISABLE_SUBTITLES_REQUEST: 'mediadisablesubtitlesrequest',
 *   MEDIA_TOGGLE_SUBTITLES_REQUEST: 'mediatogglesubtitlesrequest',
 *   MEDIA_PLAYBACK_RATE_REQUEST: 'mediaplaybackraterequest',
 *   MEDIA_RENDITION_REQUEST: 'mediarenditionrequest',
 *   MEDIA_AUDIO_TRACK_REQUEST: 'mediaaudiotrackrequest',
 *   MEDIA_SEEK_TO_LIVE_REQUEST: 'mediaseektoliverequest',
 *   REGISTER_MEDIA_STATE_RECEIVER: 'registermediastatereceiver',
 *   UNREGISTER_MEDIA_STATE_RECEIVER: 'unregistermediastatereceiver',
 * }} MediaUIEvents
 */
/** @type {MediaUIEvents} */
export const MediaUIEvents: MediaUIEvents;
export namespace MediaStateReceiverAttributes {
    const MEDIA_CHROME_ATTRIBUTES: string;
    const MEDIA_CONTROLLER: string;
}
export type MediaUIProps = {
    MEDIA_AIRPLAY_UNAVAILABLE: 'mediaAirplayUnavailable';
    MEDIA_FULLSCREEN_UNAVAILABLE: 'mediaFullscreenUnavailable';
    MEDIA_PIP_UNAVAILABLE: 'mediaPipUnavailable';
    MEDIA_CAST_UNAVAILABLE: 'mediaCastUnavailable';
    MEDIA_RENDITION_UNAVAILABLE: 'mediaRenditionUnavailable';
    MEDIA_AUDIO_TRACK_UNAVAILABLE: 'mediaAudioTrackUnavailable';
    MEDIA_PAUSED: 'mediaPaused';
    MEDIA_HAS_PLAYED: 'mediaHasPlayed';
    MEDIA_ENDED: 'mediaEnded';
    MEDIA_MUTED: 'mediaMuted';
    MEDIA_VOLUME_LEVEL: 'mediaVolumeLevel';
    MEDIA_VOLUME: 'mediaVolume';
    MEDIA_VOLUME_UNAVAILABLE: 'mediaVolumeUnavailable';
    MEDIA_IS_PIP: 'mediaIsPip';
    MEDIA_IS_CASTING: 'mediaIsCasting';
    MEDIA_IS_AIRPLAYING: 'mediaIsAirplaying';
    MEDIA_SUBTITLES_LIST: 'mediaSubtitlesList';
    MEDIA_SUBTITLES_SHOWING: 'mediaSubtitlesShowing';
    MEDIA_IS_FULLSCREEN: 'mediaIsFullscreen';
    MEDIA_PLAYBACK_RATE: 'mediaPlaybackRate';
    MEDIA_CURRENT_TIME: 'mediaCurrentTime';
    MEDIA_DURATION: 'mediaDuration';
    MEDIA_SEEKABLE: 'mediaSeekable';
    MEDIA_PREVIEW_TIME: 'mediaPreviewTime';
    MEDIA_PREVIEW_IMAGE: 'mediaPreviewImage';
    MEDIA_PREVIEW_COORDS: 'mediaPreviewCoords';
    MEDIA_PREVIEW_CHAPTER: 'mediaPreviewChapter';
    MEDIA_LOADING: 'mediaLoading';
    MEDIA_BUFFERED: 'mediaBuffered';
    MEDIA_STREAM_TYPE: 'mediaStreamType';
    MEDIA_TARGET_LIVE_WINDOW: 'mediaTargetLiveWindow';
    MEDIA_TIME_IS_LIVE: 'mediaTimeIsLive';
    MEDIA_RENDITION_LIST: 'mediaRenditionList';
    MEDIA_RENDITION_SELECTED: 'mediaRenditionSelected';
    MEDIA_AUDIO_TRACK_LIST: 'mediaAudioTrackList';
    MEDIA_AUDIO_TRACK_ENABLED: 'mediaAudioTrackEnabled';
    MEDIA_CHAPTERS_CUES: 'mediaChaptersCues';
};
/**
 * @typedef {{
 *   MEDIA_AIRPLAY_UNAVAILABLE: 'mediaAirplayUnavailable',
 *   MEDIA_FULLSCREEN_UNAVAILABLE: 'mediaFullscreenUnavailable',
 *   MEDIA_PIP_UNAVAILABLE: 'mediaPipUnavailable',
 *   MEDIA_CAST_UNAVAILABLE: 'mediaCastUnavailable',
 *   MEDIA_RENDITION_UNAVAILABLE: 'mediaRenditionUnavailable',
 *   MEDIA_AUDIO_TRACK_UNAVAILABLE: 'mediaAudioTrackUnavailable',
 *   MEDIA_PAUSED: 'mediaPaused',
 *   MEDIA_HAS_PLAYED: 'mediaHasPlayed',
 *   MEDIA_ENDED: 'mediaEnded',
 *   MEDIA_MUTED: 'mediaMuted',
 *   MEDIA_VOLUME_LEVEL: 'mediaVolumeLevel',
 *   MEDIA_VOLUME: 'mediaVolume',
 *   MEDIA_VOLUME_UNAVAILABLE: 'mediaVolumeUnavailable',
 *   MEDIA_IS_PIP: 'mediaIsPip',
 *   MEDIA_IS_CASTING: 'mediaIsCasting',
 *   MEDIA_IS_AIRPLAYING: 'mediaIsAirplaying',
 *   MEDIA_SUBTITLES_LIST: 'mediaSubtitlesList',
 *   MEDIA_SUBTITLES_SHOWING: 'mediaSubtitlesShowing',
 *   MEDIA_IS_FULLSCREEN: 'mediaIsFullscreen',
 *   MEDIA_PLAYBACK_RATE: 'mediaPlaybackRate',
 *   MEDIA_CURRENT_TIME: 'mediaCurrentTime',
 *   MEDIA_DURATION: 'mediaDuration',
 *   MEDIA_SEEKABLE: 'mediaSeekable',
 *   MEDIA_PREVIEW_TIME: 'mediaPreviewTime',
 *   MEDIA_PREVIEW_IMAGE: 'mediaPreviewImage',
 *   MEDIA_PREVIEW_COORDS: 'mediaPreviewCoords',
 *   MEDIA_PREVIEW_CHAPTER: 'mediaPreviewChapter',
 *   MEDIA_LOADING: 'mediaLoading',
 *   MEDIA_BUFFERED: 'mediaBuffered',
 *   MEDIA_STREAM_TYPE: 'mediaStreamType',
 *   MEDIA_TARGET_LIVE_WINDOW: 'mediaTargetLiveWindow',
 *   MEDIA_TIME_IS_LIVE: 'mediaTimeIsLive',
 *   MEDIA_RENDITION_LIST: 'mediaRenditionList',
 *   MEDIA_RENDITION_SELECTED: 'mediaRenditionSelected',
 *   MEDIA_AUDIO_TRACK_LIST: 'mediaAudioTrackList',
 *   MEDIA_AUDIO_TRACK_ENABLED: 'mediaAudioTrackEnabled',
 *   MEDIA_CHAPTERS_CUES: 'mediaChaptersCues',
 * }} MediaUIProps
 */
/** @type {MediaUIProps} */
export const MediaUIProps: MediaUIProps;
export namespace MediaUIAttributes {
    const MEDIA_AIRPLAY_UNAVAILABLE: string;
    const MEDIA_FULLSCREEN_UNAVAILABLE: string;
    const MEDIA_PIP_UNAVAILABLE: string;
    const MEDIA_CAST_UNAVAILABLE: string;
    const MEDIA_RENDITION_UNAVAILABLE: string;
    const MEDIA_AUDIO_TRACK_UNAVAILABLE: string;
    const MEDIA_PAUSED: string;
    const MEDIA_HAS_PLAYED: string;
    const MEDIA_ENDED: string;
    const MEDIA_MUTED: string;
    const MEDIA_VOLUME_LEVEL: string;
    const MEDIA_VOLUME: string;
    const MEDIA_VOLUME_UNAVAILABLE: string;
    const MEDIA_IS_PIP: string;
    const MEDIA_IS_CASTING: string;
    const MEDIA_IS_AIRPLAYING: string;
    const MEDIA_SUBTITLES_LIST: string;
    const MEDIA_SUBTITLES_SHOWING: string;
    const MEDIA_IS_FULLSCREEN: string;
    const MEDIA_PLAYBACK_RATE: string;
    const MEDIA_CURRENT_TIME: string;
    const MEDIA_DURATION: string;
    const MEDIA_SEEKABLE: string;
    const MEDIA_PREVIEW_TIME: string;
    const MEDIA_PREVIEW_IMAGE: string;
    const MEDIA_PREVIEW_COORDS: string;
    const MEDIA_PREVIEW_CHAPTER: string;
    const MEDIA_LOADING: string;
    const MEDIA_BUFFERED: string;
    const MEDIA_STREAM_TYPE: string;
    const MEDIA_TARGET_LIVE_WINDOW: string;
    const MEDIA_TIME_IS_LIVE: string;
    const MEDIA_RENDITION_LIST: string;
    const MEDIA_RENDITION_SELECTED: string;
    const MEDIA_AUDIO_TRACK_LIST: string;
    const MEDIA_AUDIO_TRACK_ENABLED: string;
    const MEDIA_CHAPTERS_CUES: string;
}
export namespace MediaStateChangeEvents {
    const MEDIA_AIRPLAY_UNAVAILABLE_1: string;
    export { MEDIA_AIRPLAY_UNAVAILABLE_1 as MEDIA_AIRPLAY_UNAVAILABLE };
    const MEDIA_FULLSCREEN_UNAVAILABLE_1: string;
    export { MEDIA_FULLSCREEN_UNAVAILABLE_1 as MEDIA_FULLSCREEN_UNAVAILABLE };
    const MEDIA_PIP_UNAVAILABLE_1: string;
    export { MEDIA_PIP_UNAVAILABLE_1 as MEDIA_PIP_UNAVAILABLE };
    const MEDIA_CAST_UNAVAILABLE_1: string;
    export { MEDIA_CAST_UNAVAILABLE_1 as MEDIA_CAST_UNAVAILABLE };
    const MEDIA_RENDITION_UNAVAILABLE_1: string;
    export { MEDIA_RENDITION_UNAVAILABLE_1 as MEDIA_RENDITION_UNAVAILABLE };
    const MEDIA_AUDIO_TRACK_UNAVAILABLE_1: string;
    export { MEDIA_AUDIO_TRACK_UNAVAILABLE_1 as MEDIA_AUDIO_TRACK_UNAVAILABLE };
    const MEDIA_PAUSED_1: string;
    export { MEDIA_PAUSED_1 as MEDIA_PAUSED };
    const MEDIA_HAS_PLAYED_1: string;
    export { MEDIA_HAS_PLAYED_1 as MEDIA_HAS_PLAYED };
    const MEDIA_ENDED_1: string;
    export { MEDIA_ENDED_1 as MEDIA_ENDED };
    const MEDIA_MUTED_1: string;
    export { MEDIA_MUTED_1 as MEDIA_MUTED };
    const MEDIA_VOLUME_LEVEL_1: string;
    export { MEDIA_VOLUME_LEVEL_1 as MEDIA_VOLUME_LEVEL };
    const MEDIA_VOLUME_1: string;
    export { MEDIA_VOLUME_1 as MEDIA_VOLUME };
    const MEDIA_VOLUME_UNAVAILABLE_1: string;
    export { MEDIA_VOLUME_UNAVAILABLE_1 as MEDIA_VOLUME_UNAVAILABLE };
    const MEDIA_IS_PIP_1: string;
    export { MEDIA_IS_PIP_1 as MEDIA_IS_PIP };
    const MEDIA_IS_CASTING_1: string;
    export { MEDIA_IS_CASTING_1 as MEDIA_IS_CASTING };
    const MEDIA_IS_AIRPLAYING_1: string;
    export { MEDIA_IS_AIRPLAYING_1 as MEDIA_IS_AIRPLAYING };
    const MEDIA_SUBTITLES_LIST_1: string;
    export { MEDIA_SUBTITLES_LIST_1 as MEDIA_SUBTITLES_LIST };
    const MEDIA_SUBTITLES_SHOWING_1: string;
    export { MEDIA_SUBTITLES_SHOWING_1 as MEDIA_SUBTITLES_SHOWING };
    const MEDIA_IS_FULLSCREEN_1: string;
    export { MEDIA_IS_FULLSCREEN_1 as MEDIA_IS_FULLSCREEN };
    const MEDIA_PLAYBACK_RATE_1: string;
    export { MEDIA_PLAYBACK_RATE_1 as MEDIA_PLAYBACK_RATE };
    const MEDIA_CURRENT_TIME_1: string;
    export { MEDIA_CURRENT_TIME_1 as MEDIA_CURRENT_TIME };
    const MEDIA_DURATION_1: string;
    export { MEDIA_DURATION_1 as MEDIA_DURATION };
    const MEDIA_SEEKABLE_1: string;
    export { MEDIA_SEEKABLE_1 as MEDIA_SEEKABLE };
    const MEDIA_PREVIEW_TIME_1: string;
    export { MEDIA_PREVIEW_TIME_1 as MEDIA_PREVIEW_TIME };
    const MEDIA_PREVIEW_IMAGE_1: string;
    export { MEDIA_PREVIEW_IMAGE_1 as MEDIA_PREVIEW_IMAGE };
    const MEDIA_PREVIEW_COORDS_1: string;
    export { MEDIA_PREVIEW_COORDS_1 as MEDIA_PREVIEW_COORDS };
    const MEDIA_PREVIEW_CHAPTER_1: string;
    export { MEDIA_PREVIEW_CHAPTER_1 as MEDIA_PREVIEW_CHAPTER };
    const MEDIA_LOADING_1: string;
    export { MEDIA_LOADING_1 as MEDIA_LOADING };
    const MEDIA_BUFFERED_1: string;
    export { MEDIA_BUFFERED_1 as MEDIA_BUFFERED };
    const MEDIA_STREAM_TYPE_1: string;
    export { MEDIA_STREAM_TYPE_1 as MEDIA_STREAM_TYPE };
    const MEDIA_TARGET_LIVE_WINDOW_1: string;
    export { MEDIA_TARGET_LIVE_WINDOW_1 as MEDIA_TARGET_LIVE_WINDOW };
    const MEDIA_TIME_IS_LIVE_1: string;
    export { MEDIA_TIME_IS_LIVE_1 as MEDIA_TIME_IS_LIVE };
    const MEDIA_RENDITION_LIST_1: string;
    export { MEDIA_RENDITION_LIST_1 as MEDIA_RENDITION_LIST };
    const MEDIA_RENDITION_SELECTED_1: string;
    export { MEDIA_RENDITION_SELECTED_1 as MEDIA_RENDITION_SELECTED };
    const MEDIA_AUDIO_TRACK_LIST_1: string;
    export { MEDIA_AUDIO_TRACK_LIST_1 as MEDIA_AUDIO_TRACK_LIST };
    const MEDIA_AUDIO_TRACK_ENABLED_1: string;
    export { MEDIA_AUDIO_TRACK_ENABLED_1 as MEDIA_AUDIO_TRACK_ENABLED };
    const MEDIA_CHAPTERS_CUES_1: string;
    export { MEDIA_CHAPTERS_CUES_1 as MEDIA_CHAPTERS_CUES };
    export const USER_INACTIVE: string;
    export const BREAKPOINTS_CHANGE: string;
    export const BREAKPOINTS_COMPUTED: string;
}
export namespace StateChangeEventToAttributeMap {
    const userinactivechange: string;
}
export namespace AttributeToStateChangeEventMap {
    const userinactive: string;
}
export namespace TextTrackKinds {
    const SUBTITLES: string;
    const CAPTIONS: string;
    const DESCRIPTIONS: string;
    const CHAPTERS: string;
    const METADATA: string;
}
export namespace TextTrackModes {
    const DISABLED: string;
    const HIDDEN: string;
    const SHOWING: string;
}
export namespace ReadyStates {
    const HAVE_NOTHING: number;
    const HAVE_METADATA: number;
    const HAVE_CURRENT_DATA: number;
    const HAVE_FUTURE_DATA: number;
    const HAVE_ENOUGH_DATA: number;
}
export namespace PointerTypes {
    const MOUSE: string;
    const PEN: string;
    const TOUCH: string;
}
/**
 * @type {{
 *   UNAVAILABLE: 'unavailable';
 *   UNSUPPORTED: 'unsupported';
 * }}
 */
export const AvailabilityStates: {
    UNAVAILABLE: 'unavailable';
    UNSUPPORTED: 'unsupported';
};
/**
 * @type {{
 *   LIVE: 'live';
 *   ON_DEMAND: 'on-demand';
 *   UNKNOWN: 'unknown';
 * }}
 */
export const StreamTypes: {
    LIVE: 'live';
    ON_DEMAND: 'on-demand';
    UNKNOWN: 'unknown';
};
/**
 * @type {{
 *   HIGH: 'high';
 *   MEDIUM: 'medium';
 *   LOW: 'low';
 *   OFF: 'off';
 * }}
 */
export const VolumeLevels: {
    HIGH: 'high';
    MEDIUM: 'medium';
    LOW: 'low';
    OFF: 'off';
};
/**
 * @type {{
 *   INLINE: 'inline';
 *   FULLSCREEN: 'fullscreen';
 *   PICTURE_IN_PICTURE: 'picture-in-picture';
 * }}
 */
export const WebkitPresentationModes: {
    INLINE: 'inline';
    FULLSCREEN: 'fullscreen';
    PICTURE_IN_PICTURE: 'picture-in-picture';
};
