export default MediaAudioTrackButton;
/**
 * @attr {string} mediaaudiotrackenabled - (read-only) Set to the selected audio track id.
 * @attr {(unavailable|unsupported)} mediaaudiotrackunavailable - (read-only) Set if audio track selection is unavailable.
 *
 * @cssproperty [--media-audio-track-button-display = inline-flex] - `display` property of button.
 */
export class MediaAudioTrackButton extends MediaChromeButton {
    constructor();
    set mediaAudioTrackEnabled(arg: string);
    /**
     * Get enabled audio track id.
     * @return {string}
     */
    get mediaAudioTrackEnabled(): string;
}
import { MediaChromeButton } from "../media-chrome-button.js";
