export default MediaCaptionsListbox;
/**
 * @slot captions-indicator - An icon element indicating an option with closed captions.
 *
 * @attr {string} mediasubtitleslist - (read-only) A list of all subtitles and captions.
 * @attr {boolean} mediasubtitlesshowing - (read-only) A list of the showing subtitles and captions.
 */
export class MediaCaptionsListbox extends MediaChromeListbox {
    constructor();
    set mediaSubtitlesList(arg: any[]);
    /**
     * @type {Array<object>} An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesList(): any[];
    set mediaSubtitlesShowing(arg: any[]);
    /**
     * @type {Array<object>} An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesShowing(): any[];
    #private;
}
import { MediaChromeListbox } from "./media-chrome-listbox.js";
