export function createOption(text: any, value: any, selected: any): any;
export function createIndicator(el: any, name: any): any;
export default MediaChromeListbox;
/**
 * @extends {HTMLElement}
 *
 * @slot - Default slotted elements.
 * @slot header - An element shown at the top of the listbox.
 * @slot select-indicator - An icon element indicating a selected option.
 *
 * @attr {boolean} disabled - The Boolean disabled attribute makes the element not mutable or focusable.
 * @attr {string} mediacontroller - The element `id` of the media controller to connect to (if not nested within).
 *
 * @cssproperty --media-primary-color - Default color of text / icon.
 * @cssproperty --media-secondary-color - Default color of background.
 * @cssproperty --media-text-color - `color` of text.
 *
 * @cssproperty --media-control-background - `background` of control.
 * @cssproperty --media-listbox-layout - Set to `row` for a horizontal listbox design.
 * @cssproperty --media-listbox-flex-direction - `flex-direction` of listbox.
 * @cssproperty --media-listbox-gap - `gap` between listbox options.
 * @cssproperty --media-listbox-background - `background` of listbox.
 * @cssproperty --media-listbox-border-radius - `border-radius` of listbox.
 *
 * @cssproperty --media-font - `font` shorthand property.
 * @cssproperty --media-font-weight - `font-weight` property.
 * @cssproperty --media-font-family - `font-family` property.
 * @cssproperty --media-font-size - `font-size` property.
 * @cssproperty --media-text-content-height - `line-height` of text.
 *
 * @cssproperty --media-icon-color - `fill` color of icon.
 * @cssproperty --media-option-indicator-fill - `fill` color of indicator icon.
 * @cssproperty --media-option-indicator-height - `height` of option indicator.
 * @cssproperty --media-option-indicator-vertical-align - `vertical-align` of option indicator.
 * @cssproperty --media-option-select-indicator-display - `display` of select indicator.
 */
export class MediaChromeListbox extends HTMLElement {
    static get observedAttributes(): string[];
    static formatOptionText(text: any): any;
    constructor(options?: {});
    nativeEl: any;
    container: Element;
    formatOptionText(text: any, data: any): any;
    get options(): HTMLOptionElement[];
    get selectedOptions(): HTMLOptionElement[];
    set value(arg: string);
    get value(): string;
    focus(): void;
    enable(): void;
    disable(): void;
    attributeChangedCallback(attrName: any, oldValue: any, newValue: any): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    get keysUsed(): string[];
    handleSelection(e: any, toggle: any): void;
    handleMovement(e: any): void;
    handleClick(e: any): void;
    #private;
}
