export namespace Attributes {
    const RATES: string;
}
export default MediaPlaybackRateListbox;
/**
 * @attr {string} rates - Set custom playback rates for the user to choose from.
 * @attr {string} mediaplaybackrate - (read-only) Set to the media playback rate.
 */
export class MediaPlaybackRateListbox extends MediaChromeListbox {
    constructor();
    set rates(arg: number[] | AttributeTokenList);
    /**
     * @type { AttributeTokenList | Array<number> | undefined} Will return a DOMTokenList.
     * Setting a value will accept an array of numbers.
     */
    get rates(): number[] | AttributeTokenList;
    set mediaPlaybackRate(arg: number);
    /**
     * @type {number} The current playback rate
     */
    get mediaPlaybackRate(): number;
    #private;
}
import { MediaChromeListbox } from "./media-chrome-listbox.js";
import { AttributeTokenList } from "../utils/attribute-token-list.js";
