export default MediaAirplayButton;
/**
 * @slot enter - An element shown when the media is not in AirPlay mode and pressing the button will open the AirPlay menu.
 * @slot exit - An element shown when the media is in AirPlay mode and pressing the button will open the AirPlay menu.
 * @slot icon - The element shown for the AirPlay button’s display.
 *
 * @attr {(unavailable|unsupported)} mediaairplayunavailable - (read-only) Set if AirPlay is unavailable.
 * @attr {boolean} mediaisairplaying - (read-only) Present if the media is airplaying.
 *
 * @cssproperty [--media-airplay-button-display = inline-flex] - `display` property of button.
 *
 * @event {CustomEvent} mediaairplayrequest
 */
declare class MediaAirplayButton extends MediaChromeButton {
    set mediaIsAirplaying(arg: boolean);
    /**
     * @type {boolean} Are we currently airplaying
     */
    get mediaIsAirplaying(): boolean;
    set mediaAirplayUnavailable(arg: string);
    /**
     * @type {string | undefined} Airplay unavailability state
     */
    get mediaAirplayUnavailable(): string;
    handleClick(): void;
}
import { MediaChromeButton } from "./media-chrome-button.js";
