export default MediaAudioTrackMenu;
/**
 * @extends {MediaChromeMenu}
 *
 * @slot - Default slotted elements.
 * @slot header - An element shown at the top of the menu.
 * @slot checked-indicator - An icon element indicating a checked menu-item.
 *
 * @attr {string} mediaaudiotrackenabled - (read-only) Set to the enabled audio track.
 * @attr {string} mediaaudiotracklist - (read-only) Set to the audio track list.
 */
export class MediaAudioTrackMenu extends MediaChromeMenu {
    set mediaAudioTrackList(arg: any[]);
    get mediaAudioTrackList(): any[];
    set mediaAudioTrackEnabled(arg: string);
    /**
     * Get enabled audio track id.
     * @return {string}
     */
    get mediaAudioTrackEnabled(): string;
    #private;
}
import { MediaChromeMenu } from "./media-chrome-menu.js";
