export default MediaCaptionsMenu;
/**
 * @extends {MediaChromeMenu}
 *
 * @slot - Default slotted elements.
 * @slot header - An element shown at the top of the menu.
 * @slot checked-indicator - An icon element indicating a checked menu-item.
 * @slot captions-indicator - An icon element indicating an item with closed captions.
 *
 * @attr {string} mediasubtitleslist - (read-only) A list of all subtitles and captions.
 * @attr {boolean} mediasubtitlesshowing - (read-only) A list of the showing subtitles and captions.
 */
export class MediaCaptionsMenu extends MediaChromeMenu {
    set mediaSubtitlesList(arg: any[]);
    /**
     * @type {Array<object>} An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesList(): any[];
    set mediaSubtitlesShowing(arg: any[]);
    /**
     * @type {Array<object>} An array of TextTrack-like objects.
     * Objects must have the properties: kind, language, and label.
     */
    get mediaSubtitlesShowing(): any[];
    #private;
}
import { MediaChromeMenu } from "./media-chrome-menu.js";
