export namespace Attributes {
    const HIDDEN: string;
    const ANCHOR: string;
}
export default MediaChromeDialog;
/**
 * @extends {HTMLElement}
 *
 * @slot - Default slotted elements.
 *
 * @cssproperty --media-primary-color - Default color of text / icon.
 * @cssproperty --media-secondary-color - Default color of background.
 * @cssproperty --media-text-color - `color` of text.
 *
 * @cssproperty --media-control-background - `background` of control.
 * @cssproperty --media-dialog-display - `display` of dialog.
 * @cssproperty --media-dialog-background - `background` of dialog.
 * @cssproperty --media-dialog-border-radius - `border-radius` of dialog.
 * @cssproperty --media-dialog-border - `border` of dialog.
 * @cssproperty --media-dialog-transition-in - `transition` of dialog when showing.
 * @cssproperty --media-dialog-transition-out - `transition` of dialog when hiding.
 * @cssproperty --media-dialog-visibility - `visibility` of dialog when showing.
 * @cssproperty --media-dialog-hidden-visibility - `visibility` of dialog when hiding.
 * @cssproperty --media-dialog-opacity - `opacity` of dialog when showing.
 * @cssproperty --media-dialog-hidden-opacity - `opacity` of dialog when hiding.
 * @cssproperty --media-dialog-transform-in - `transform` of dialog when showing.
 * @cssproperty --media-dialog-transform-out - `transform` of dialog when hiding.
 *
 * @cssproperty --media-font - `font` shorthand property.
 * @cssproperty --media-font-weight - `font-weight` property.
 * @cssproperty --media-font-family - `font-family` property.
 * @cssproperty --media-font-size - `font-size` property.
 * @cssproperty --media-text-content-height - `line-height` of text.
 */
export class MediaChromeDialog extends HTMLElement {
    static template: any;
    static get observedAttributes(): string[];
    nativeEl: any;
    handleEvent(event: any): void;
    connectedCallback(): void;
    role: string;
    attributeChangedCallback(attrName: any, oldValue: any, newValue: any): void;
    focus(): void;
    get keysUsed(): string[];
    #private;
}
