export namespace Attributes {
    const TYPE: string;
    const VALUE: string;
    const CHECKED: string;
    const DISABLED: string;
}
export default MediaChromeMenuItem;
export type MediaChromeMenu = import('./media-chrome-menu.js').MediaChromeMenu;
/**
 * @extends {HTMLElement}
 * @slot - Default slotted elements.
 *
 * @attr {(''|'radio'|'checkbox')} type - This attribute indicates the kind of command, and can be one of three values.
 * @attr {boolean} disabled - The Boolean disabled attribute makes the element not mutable or focusable.
 *
 * @cssproperty --media-menu-item-opacity - `opacity` of menu-item content.
 * @cssproperty --media-menu-item-transition - `transition` of menu-item.
 * @cssproperty --media-menu-item-checked-background - `background` of checked menu-item.
 * @cssproperty --media-menu-item-outline - `outline` menu-item.
 * @cssproperty --media-menu-item-outline-offset - `outline-offset` of menu-item.
 * @cssproperty --media-menu-item-hover-background - `background` of hovered menu-item.
 * @cssproperty --media-menu-item-hover-outline - `outline` of hovered menu-item.
 * @cssproperty --media-menu-item-hover-outline-offset - `outline-offset` of hovered menu-item.
 * @cssproperty --media-menu-item-focus-shadow - `box-shadow` of the :focus-visible state.
 * @cssproperty --media-menu-item-icon-height - `height` of icon.
 * @cssproperty --media-menu-item-description-max-width - `max-width` of description.
 * @cssproperty --media-menu-item-checked-indicator-display - `display` of checked indicator.
 *
 * @cssproperty --media-icon-color - `fill` color of icon.
 * @cssproperty --media-menu-icon-height - `height` of icon.
 *
 * @cssproperty --media-menu-item-indicator-fill - `fill` color of indicator icon.
 * @cssproperty --media-menu-item-indicator-height - `height` of menu-item indicator.
 */
export class MediaChromeMenuItem extends HTMLElement {
    static template: any;
    static get observedAttributes(): string[];
    enable(): void;
    disable(): void;
    handleEvent(event: any): void;
    attributeChangedCallback(attrName: any, oldValue: any, newValue: any): void;
    role: string;
    connectedCallback(): void;
    disconnectedCallback(): void;
    set invokeTarget(arg: string);
    get invokeTarget(): string;
    /**
     * Returns the element with the id specified by the `invoketarget` attribute
     * or the slotted submenu element.
     * @return {MediaChromeMenu | null}
     */
    get invokeTargetElement(): import("./media-chrome-menu.js").MediaChromeMenu;
    /**
     * Returns the slotted submenu element.
     */
    get submenuElement(): import("./media-chrome-menu.js").MediaChromeMenu;
    set type(arg: string);
    get type(): string;
    set value(arg: string);
    get value(): string;
    get text(): string;
    set checked(arg: boolean);
    get checked(): boolean;
    handleClick(event: any): void;
    get keysUsed(): string[];
    #private;
}
