/** @typedef {import('./media-chrome-menu-item.js').MediaChromeMenuItem} MediaChromeMenuItem */
export function createMenuItem({ type, text, value, checked }: {
    type: any;
    text: any;
    value: any;
    checked: any;
}): any;
export function createIndicator(el: any, name: any): any;
export namespace Attributes {
    const STYLE: string;
    const HIDDEN: string;
    const DISABLED: string;
    const ANCHOR: string;
}
export default MediaChromeMenu;
export type MediaChromeMenuItem = import('./media-chrome-menu-item.js').MediaChromeMenuItem;
/**
 * @extends {HTMLElement}
 *
 * @slot - Default slotted elements.
 * @slot header - An element shown at the top of the menu.
 * @slot checked-indicator - An icon element indicating a checked menu-item.
 *
 * @attr {boolean} disabled - The Boolean disabled attribute makes the element not mutable or focusable.
 * @attr {string} mediacontroller - The element `id` of the media controller to connect to (if not nested within).
 *
 * @cssproperty --media-primary-color - Default color of text / icon.
 * @cssproperty --media-secondary-color - Default color of background.
 * @cssproperty --media-text-color - `color` of text.
 *
 * @cssproperty --media-control-background - `background` of control.
 * @cssproperty --media-menu-display - `display` of menu.
 * @cssproperty --media-menu-layout - Set to `row` for a horizontal menu design.
 * @cssproperty --media-menu-flex-direction - `flex-direction` of menu.
 * @cssproperty --media-menu-gap - `gap` between menu items.
 * @cssproperty --media-menu-background - `background` of menu.
 * @cssproperty --media-menu-border-radius - `border-radius` of menu.
 * @cssproperty --media-menu-border - `border` of menu.
 * @cssproperty --media-menu-transition-in - `transition` of menu when showing.
 * @cssproperty --media-menu-transition-out - `transition` of menu when hiding.
 * @cssproperty --media-menu-visibility - `visibility` of menu when showing.
 * @cssproperty --media-menu-hidden-visibility - `visibility` of menu when hiding.
 * @cssproperty --media-menu-max-height - `max-height` of menu.
 * @cssproperty --media-menu-hidden-max-height - `max-height` of menu when hiding.
 * @cssproperty --media-menu-opacity - `opacity` of menu when showing.
 * @cssproperty --media-menu-hidden-opacity - `opacity` of menu when hiding.
 * @cssproperty --media-menu-transform-in - `transform` of menu when showing.
 * @cssproperty --media-menu-transform-out - `transform` of menu when hiding.
 *
 * @cssproperty --media-font - `font` shorthand property.
 * @cssproperty --media-font-weight - `font-weight` property.
 * @cssproperty --media-font-family - `font-family` property.
 * @cssproperty --media-font-size - `font-size` property.
 * @cssproperty --media-text-content-height - `line-height` of text.
 *
 * @cssproperty --media-icon-color - `fill` color of icon.
 * @cssproperty --media-menu-icon-height - `height` of icon.
 * @cssproperty --media-menu-item-checked-indicator-display - `display` of check indicator.
 * @cssproperty --media-menu-item-checked-background - `background` of checked menu item.
 * @cssproperty --media-menu-item-max-width - `max-width` of menu item text.
 */
export class MediaChromeMenu extends HTMLElement {
    static template: any;
    static get observedAttributes(): string[];
    static formatMenuItemText(text: any): any;
    nativeEl: any;
    /** @type {HTMLElement} */
    container: HTMLElement;
    /** @type {HTMLSlotElement} */
    defaultSlot: HTMLSlotElement;
    enable(): void;
    disable(): void;
    handleEvent(event: any): void;
    connectedCallback(): void;
    role: string;
    disconnectedCallback(): void;
    attributeChangedCallback(attrName: any, oldValue: any, newValue: any): void;
    formatMenuItemText(text: any, data: any): any;
    set anchor(arg: string);
    get anchor(): string;
    /**
     * Returns the anchor element when it is a floating menu.
     * @return {HTMLElement}
     */
    get anchorElement(): HTMLElement;
    /**
     * Returns the menu items.
     */
    get items(): import("./media-chrome-menu-item.js").MediaChromeMenuItem[];
    get radioGroupItems(): import("./media-chrome-menu-item.js").MediaChromeMenuItem[];
    get checkedItems(): import("./media-chrome-menu-item.js").MediaChromeMenuItem[];
    set value(arg: string);
    get value(): string;
    focus(): void;
    handleSelect(event: any): void;
    get keysUsed(): string[];
    handleMove(event: any): void;
    #private;
}
