export namespace Attributes {
    const RATES: string;
}
export default MediaPlaybackRateMenu;
/**
 * @extends {MediaChromeMenu}
 *
 * @slot - Default slotted elements.
 * @slot header - An element shown at the top of the menu.
 * @slot checked-indicator - An icon element indicating a checked menu-item.
 *
 * @attr {string} rates - Set custom playback rates for the user to choose from.
 * @attr {string} mediaplaybackrate - (read-only) Set to the media playback rate.
 */
export class MediaPlaybackRateMenu extends MediaChromeMenu {
    set rates(arg: number[] | AttributeTokenList);
    /**
     * @type { AttributeTokenList | Array<number> | undefined} Will return a DOMTokenList.
     * Setting a value will accept an array of numbers.
     */
    get rates(): number[] | AttributeTokenList;
    set mediaPlaybackRate(arg: number);
    /**
     * @type {number} The current playback rate
     */
    get mediaPlaybackRate(): number;
    #private;
}
import { MediaChromeMenu } from "./media-chrome-menu.js";
import { AttributeTokenList } from "./utils/attribute-token-list.js";
