export default MediaRenditionMenu;
/**
 * @extends {MediaChromeMenu}
 *
 * @slot - Default slotted elements.
 * @slot header - An element shown at the top of the menu.
 * @slot checked-indicator - An icon element indicating a checked menu-item.
 *
 * @attr {string} mediarenditionselected - (read-only) Set to the selected rendition id.
 * @attr {string} mediarenditionlist - (read-only) Set to the rendition list.
 */
export class MediaRenditionMenu extends MediaChromeMenu {
    set mediaRenditionList(arg: any[]);
    get mediaRenditionList(): any[];
    set mediaRenditionSelected(arg: string);
    /**
     * Get selected rendition id.
     * @return {string}
     */
    get mediaRenditionSelected(): string;
    #private;
}
import { MediaChromeMenu } from "./media-chrome-menu.js";
