/**
 * @typedef {Omit<
 *  MediaUIEvents,
 *  'REGISTER_MEDIA_STATE_RECEIVER' |
 *  'UNREGISTER_MEDIA_STATE_RECEIVER' |
 *  'MEDIA_SHOW_TEXT_TRACKS_REQUEST' |
 *  'MEDIA_HIDE_TEXT_TRACKS_REQUEST'
 * >} MediaRequestTypes
 */
/**
 * @typedef {import('./state-mediator.js').StateMediator} StateMediator
 */
/**
 * @typedef {import('./state-mediator.js').StateOwners} StateOwners
 */
/** @TODO Duplicate definition (See media-store.js). Consolidate somewhere */
/**
 * @typedef {{
 *   [K in keyof StateMediator]: ReturnType<StateMediator[K]['get']>
 * } & {
 *   mediaPreviewTime: number;
 *   mediaPreviewImage: string;
 *   mediaPreviewCoords: [number,number,number,number]
 * }} MediaState
 */
/** @TODO Make this definition more precise (CJP) */
/**
 *
 * RequestMap provides a stateless, well-defined API for translating state change requests to related side effects to attempt to fulfill said request and
 * any other appropriate state changes that should occur as a result. Most often (but not always), those will simply rely on the StateMediator's `set()`
 * method for the corresponding state to update the StateOwners state. RequestMap is designed to be used by a MediaStore, which owns all of the wiring up
 * and persistence of e.g. StateOwners, MediaState, StateMediator, and the RequestMap.
 *
 * For any modeled state change request, the RequestMap defines a key, K, which directly maps to the state change request type (e.g. `mediapauserequest`, `mediaseekrequest`, etc.),
 * whose value is a function that defines the appropriate side effects of the request that will, under normal circumstances, (eventually) result in actual state changes.
 *
 * @typedef {{ [k in MediaRequestTypes[keyof MediaRequestTypes]]: (
 *  stateMediator: StateMediator,
 *  stateOwners: StateOwners,
 *  action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>
 * ) => Partial<MediaState>|undefined|void}} RequestMap
 */
/** @type {RequestMap} */
export const requestMap: RequestMap;
export type MediaRequestTypes = Omit<MediaUIEvents, 'REGISTER_MEDIA_STATE_RECEIVER' | 'UNREGISTER_MEDIA_STATE_RECEIVER' | 'MEDIA_SHOW_TEXT_TRACKS_REQUEST' | 'MEDIA_HIDE_TEXT_TRACKS_REQUEST'>;
export type StateMediator = import('./state-mediator.js').StateMediator;
export type StateOwners = import('./state-mediator.js').StateOwners;
export type MediaState = {
    mediaPaused: boolean;
    mediaHasPlayed: boolean;
    mediaEnded: boolean;
    mediaPlaybackRate: number;
    mediaMuted: boolean;
    mediaVolume: number;
    mediaVolumeLevel: "high" | "medium" | "low" | "off";
    mediaCurrentTime: number;
    mediaDuration: number;
    mediaLoading: boolean;
    mediaSeekable: [number, number];
    mediaBuffered: [number, number][];
    mediaStreamType: import("./state-mediator.js").StreamTypeValue;
    mediaTargetLiveWindow: number;
    mediaTimeIsLive: boolean;
    mediaSubtitlesList: Pick<TextTrack, "kind" | "language" | "label">[];
    mediaSubtitlesShowing: Pick<TextTrack, "kind" | "language" | "label">[];
    mediaChaptersCues: Pick<VTTCue, "text" | "startTime" | "endTime">[];
    mediaIsPip: boolean;
    mediaRenditionList: import("./state-mediator.js").Rendition[];
    mediaRenditionSelected: string;
    mediaAudioTrackList: {
        id?: string;
    }[];
    mediaAudioTrackEnabled: string;
    mediaIsFullscreen: boolean;
    mediaIsCasting: boolean;
    mediaIsAirplaying: boolean;
    mediaFullscreenUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
    mediaPipUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
    mediaVolumeUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
    mediaCastUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
    mediaAirplayUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
    mediaRenditionUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
    mediaAudioTrackUnavailable: import("./state-mediator.js").AvailabilityTypeValue;
} & {
    mediaPreviewTime: number;
    mediaPreviewImage: string;
    mediaPreviewCoords: [number, number, number, number];
};
/**
 *
 * RequestMap provides a stateless, well-defined API for translating state change requests to related side effects to attempt to fulfill said request and
 * any other appropriate state changes that should occur as a result. Most often (but not always), those will simply rely on the StateMediator's `set()`
 * method for the corresponding state to update the StateOwners state. RequestMap is designed to be used by a MediaStore, which owns all of the wiring up
 * and persistence of e.g. StateOwners, MediaState, StateMediator, and the RequestMap.
 *
 * For any modeled state change request, the RequestMap defines a key, K, which directly maps to the state change request type (e.g. `mediapauserequest`, `mediaseekrequest`, etc.),
 * whose value is a function that defines the appropriate side effects of the request that will, under normal circumstances, (eventually) result in actual state changes.
 */
export type RequestMap = {
    mediaplayrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediapauserequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediamuterequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaunmuterequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediavolumerequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaseekrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaairplayrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaenterfullscreenrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaexitfullscreenrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediapreviewrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaenterpiprequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaexitpiprequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaentercastrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaexitcastrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediashowsubtitlesrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediadisablesubtitlesrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediatogglesubtitlesrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaplaybackraterequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediarenditionrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaaudiotrackrequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
    mediaseektoliverequest: (stateMediator: StateMediator, stateOwners: StateOwners, action: Partial<Pick<CustomEvent<any>, 'type' | 'detail'>>) => Partial<MediaState> | undefined | void;
};
import { MediaUIEvents } from "../constants.js";
