import type React from 'react';

import type * as CSS from 'csstype';
declare global {
  interface Element {
    slot?: string;
  }
}

declare module 'csstype' {
  interface Properties {
    // Should add generic support for any CSS variables
    [index: `--${string}`]: any;
  }
}

type GenericProps = { [k: string]: any };
type GenericElement = HTMLElement;

type GenericForwardRef = React.ForwardRefExoticComponent<
  GenericProps & React.RefAttributes<GenericElement | undefined>
>;

declare const MediaGestureReceiver: GenericForwardRef;
export { MediaGestureReceiver };

declare const MediaContainer: GenericForwardRef;
export { MediaContainer };

declare const MediaController: GenericForwardRef;
export { MediaController };

declare const MediaChromeButton: GenericForwardRef;
export { MediaChromeButton };

declare const MediaAirplayButton: GenericForwardRef;
export { MediaAirplayButton };

declare const MediaChromeMenu: GenericForwardRef;
export { MediaChromeMenu };

declare const MediaAudioTrackMenu: GenericForwardRef;
export { MediaAudioTrackMenu };

declare const MediaChromeMenuButton: GenericForwardRef;
export { MediaChromeMenuButton };

declare const MediaAudioTrackMenuButton: GenericForwardRef;
export { MediaAudioTrackMenuButton };

declare const MediaCaptionsButton: GenericForwardRef;
export { MediaCaptionsButton };

declare const MediaCaptionsMenu: GenericForwardRef;
export { MediaCaptionsMenu };

declare const MediaCaptionsMenuButton: GenericForwardRef;
export { MediaCaptionsMenuButton };

declare const MediaCastButton: GenericForwardRef;
export { MediaCastButton };

declare const MediaChromeDialog: GenericForwardRef;
export { MediaChromeDialog };

declare const MediaChromeMenuItem: GenericForwardRef;
export { MediaChromeMenuItem };

declare const MediaChromeRange: GenericForwardRef;
export { MediaChromeRange };

declare const MediaControlBar: GenericForwardRef;
export { MediaControlBar };

declare const MediaTextDisplay: GenericForwardRef;
export { MediaTextDisplay };

declare const MediaDurationDisplay: GenericForwardRef;
export { MediaDurationDisplay };

declare const MediaFullscreenButton: GenericForwardRef;
export { MediaFullscreenButton };

declare const MediaLiveButton: GenericForwardRef;
export { MediaLiveButton };

declare const MediaLoadingIndicator: GenericForwardRef;
export { MediaLoadingIndicator };

declare const MediaMuteButton: GenericForwardRef;
export { MediaMuteButton };

declare const MediaPipButton: GenericForwardRef;
export { MediaPipButton };

declare const MediaPlaybackRateButton: GenericForwardRef;
export { MediaPlaybackRateButton };

declare const MediaPlaybackRateMenu: GenericForwardRef;
export { MediaPlaybackRateMenu };

declare const MediaPlaybackRateMenuButton: GenericForwardRef;
export { MediaPlaybackRateMenuButton };

declare const MediaPlayButton: GenericForwardRef;
export { MediaPlayButton };

declare const MediaPosterImage: GenericForwardRef;
export { MediaPosterImage };

declare const MediaPreviewChapterDisplay: GenericForwardRef;
export { MediaPreviewChapterDisplay };

declare const MediaPreviewThumbnail: GenericForwardRef;
export { MediaPreviewThumbnail };

declare const MediaPreviewTimeDisplay: GenericForwardRef;
export { MediaPreviewTimeDisplay };

declare const MediaRenditionMenu: GenericForwardRef;
export { MediaRenditionMenu };

declare const MediaRenditionMenuButton: GenericForwardRef;
export { MediaRenditionMenuButton };

declare const MediaSeekBackwardButton: GenericForwardRef;
export { MediaSeekBackwardButton };

declare const MediaSeekForwardButton: GenericForwardRef;
export { MediaSeekForwardButton };

declare const MediaSettingsMenu: GenericForwardRef;
export { MediaSettingsMenu };

declare const MediaSettingsMenuButton: GenericForwardRef;
export { MediaSettingsMenuButton };

declare const MediaSettingsMenuItem: GenericForwardRef;
export { MediaSettingsMenuItem };

declare const MediaTimeDisplay: GenericForwardRef;
export { MediaTimeDisplay };

declare const MediaTimeRange: GenericForwardRef;
export { MediaTimeRange };

declare const MediaVolumeRange: GenericForwardRef;
export { MediaVolumeRange };
