import React from "react";
import "../index.js";
import { toNativeProps } from "./common/utils.js";

/** @type { import("react").HTMLElement } */
const MediaGestureReceiver = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-gesture-receiver', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaGestureReceiver };

/** @type { import("react").HTMLElement } */
const MediaContainer = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-container', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaContainer };

/** @type { import("react").HTMLElement } */
const MediaController = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-controller', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaController };

/** @type { import("react").HTMLElement } */
const MediaChromeButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-chrome-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaChromeButton };

/** @type { import("react").HTMLElement } */
const MediaAirplayButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-airplay-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaAirplayButton };

/** @type { import("react").HTMLElement } */
const MediaChromeMenu = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-chrome-menu', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaChromeMenu };

/** @type { import("react").HTMLElement } */
const MediaAudioTrackMenu = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-audio-track-menu', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaAudioTrackMenu };

/** @type { import("react").HTMLElement } */
const MediaChromeMenuButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-chrome-menu-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaChromeMenuButton };

/** @type { import("react").HTMLElement } */
const MediaAudioTrackMenuButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-audio-track-menu-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaAudioTrackMenuButton };

/** @type { import("react").HTMLElement } */
const MediaCaptionsButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-captions-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaCaptionsButton };

/** @type { import("react").HTMLElement } */
const MediaCaptionsMenu = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-captions-menu', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaCaptionsMenu };

/** @type { import("react").HTMLElement } */
const MediaCaptionsMenuButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-captions-menu-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaCaptionsMenuButton };

/** @type { import("react").HTMLElement } */
const MediaCastButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-cast-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaCastButton };

/** @type { import("react").HTMLElement } */
const MediaChromeDialog = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-chrome-dialog', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaChromeDialog };

/** @type { import("react").HTMLElement } */
const MediaChromeMenuItem = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-chrome-menu-item', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaChromeMenuItem };

/** @type { import("react").HTMLElement } */
const MediaChromeRange = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-chrome-range', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaChromeRange };

/** @type { import("react").HTMLElement } */
const MediaControlBar = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-control-bar', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaControlBar };

/** @type { import("react").HTMLElement } */
const MediaTextDisplay = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-text-display', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaTextDisplay };

/** @type { import("react").HTMLElement } */
const MediaDurationDisplay = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-duration-display', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaDurationDisplay };

/** @type { import("react").HTMLElement } */
const MediaFullscreenButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-fullscreen-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaFullscreenButton };

/** @type { import("react").HTMLElement } */
const MediaLiveButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-live-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaLiveButton };

/** @type { import("react").HTMLElement } */
const MediaLoadingIndicator = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-loading-indicator', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaLoadingIndicator };

/** @type { import("react").HTMLElement } */
const MediaMuteButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-mute-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaMuteButton };

/** @type { import("react").HTMLElement } */
const MediaPipButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-pip-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPipButton };

/** @type { import("react").HTMLElement } */
const MediaPlaybackRateButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-playback-rate-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPlaybackRateButton };

/** @type { import("react").HTMLElement } */
const MediaPlaybackRateMenu = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-playback-rate-menu', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPlaybackRateMenu };

/** @type { import("react").HTMLElement } */
const MediaPlaybackRateMenuButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-playback-rate-menu-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPlaybackRateMenuButton };

/** @type { import("react").HTMLElement } */
const MediaPlayButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-play-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPlayButton };

/** @type { import("react").HTMLElement } */
const MediaPosterImage = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-poster-image', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPosterImage };

/** @type { import("react").HTMLElement } */
const MediaPreviewChapterDisplay = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-preview-chapter-display', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPreviewChapterDisplay };

/** @type { import("react").HTMLElement } */
const MediaPreviewThumbnail = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-preview-thumbnail', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPreviewThumbnail };

/** @type { import("react").HTMLElement } */
const MediaPreviewTimeDisplay = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-preview-time-display', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaPreviewTimeDisplay };

/** @type { import("react").HTMLElement } */
const MediaRenditionMenu = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-rendition-menu', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaRenditionMenu };

/** @type { import("react").HTMLElement } */
const MediaRenditionMenuButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-rendition-menu-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaRenditionMenuButton };

/** @type { import("react").HTMLElement } */
const MediaSeekBackwardButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-seek-backward-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaSeekBackwardButton };

/** @type { import("react").HTMLElement } */
const MediaSeekForwardButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-seek-forward-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaSeekForwardButton };

/** @type { import("react").HTMLElement } */
const MediaSettingsMenu = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-settings-menu', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaSettingsMenu };

/** @type { import("react").HTMLElement } */
const MediaSettingsMenuButton = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-settings-menu-button', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaSettingsMenuButton };

/** @type { import("react").HTMLElement } */
const MediaSettingsMenuItem = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-settings-menu-item', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaSettingsMenuItem };

/** @type { import("react").HTMLElement } */
const MediaTimeDisplay = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-time-display', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaTimeDisplay };

/** @type { import("react").HTMLElement } */
const MediaTimeRange = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-time-range', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaTimeRange };

/** @type { import("react").HTMLElement } */
const MediaVolumeRange = React.forwardRef(({ children = [], ...props }, ref) => {
  return React.createElement('media-volume-range', toNativeProps({ ...props, suppressHydrationWarning: true, ref }), children);
});

export { MediaVolumeRange };
