/**
 * Dispatch an InvokeEvent on the target element to perform an action.
 * The default action is auto, which is determined by the target element.
 * In our case it's only used for toggling a menu.
 */
export class InvokeEvent extends Event {
    /** @param  {EventInit & { action?: string, relatedTarget: Element }} init */
    constructor({ action, relatedTarget, ...options }: EventInit & {
        action?: string;
        relatedTarget: Element;
    });
    /** @type {string} */
    action: string;
    /** @type {Element} */
    relatedTarget: Element;
}
/**
 * Similar to the popover toggle event.
 * https://developer.mozilla.org/en-US/docs/Web/API/ToggleEvent
 */
export class ToggleEvent extends Event {
    /**
     * @param  {EventInit & { newState: 'open' | 'closed', oldState: 'open' | 'closed' }} init
     */
    constructor({ newState, oldState, ...options }: EventInit & {
        newState: 'open' | 'closed';
        oldState: 'open' | 'closed';
    });
    /** @type {'open' | 'closed'} */
    newState: 'open' | 'closed';
    /** @type {'open' | 'closed'} */
    oldState: 'open' | 'closed';
}
