/**
 * @typedef {Partial<HTMLVideoElement> & {
 *  webkitDisplayingFullscreen?: boolean;
 *  webkitPresentationMode?: 'fullscreen'|'picture-in-picture';
 *  webkitEnterFullscreen?: () => any;
 * }} MediaStateOwner
 */
/**
 * @typedef {Partial<Document|ShadowRoot>} RootNodeStateOwner
 */
/**
 * @typedef {Partial<HTMLElement>} FullScreenElementStateOwner
 */
/**
 * @typedef {object} StateOwners
 * @property {MediaStateOwner} [media]
 * @property {RootNodeStateOwner} [documentElement]
 * @property {FullScreenElementStateOwner} [fullscreenElement]
 */
/** @type {(stateOwners: StateOwners) => Promise<undefined> | undefined} */
export const enterFullscreen: (stateOwners: StateOwners) => Promise<undefined> | undefined;
/** @type {(stateOwners: StateOwners) => Promise<undefined> | undefined} */
export const exitFullscreen: (stateOwners: StateOwners) => Promise<undefined> | undefined;
/** @type {(stateOwners: StateOwners) => FullScreenElementStateOwner | null | undefined} */
export const getFullscreenElement: (stateOwners: StateOwners) => FullScreenElementStateOwner | null | undefined;
/** @type {(stateOwners: StateOwners) => boolean} */
export const isFullscreen: (stateOwners: StateOwners) => boolean;
/** @type {(stateOwners: StateOwners) => boolean} */
export const isFullscreenEnabled: (stateOwners: StateOwners) => boolean;
export type MediaStateOwner = Partial<HTMLVideoElement> & {
    webkitDisplayingFullscreen?: boolean;
    webkitPresentationMode?: 'fullscreen' | 'picture-in-picture';
    webkitEnterFullscreen?: () => any;
};
export type RootNodeStateOwner = Partial<Document | ShadowRoot>;
export type FullScreenElementStateOwner = Partial<HTMLElement>;
export type StateOwners = {
    media?: MediaStateOwner;
    documentElement?: RootNodeStateOwner;
    fullscreenElement?: FullScreenElementStateOwner;
};
