export const isServer: boolean;
/**
 * @type { globalThis & {
 *   WebKitPlaybackTargetAvailabilityEvent?,
 *   chrome?,
 *   DocumentFragment?,
 *   getComputedStyle,
 *   CastableVideoElement?
 * } |
 * {Node,
 * HTMLElement,
 * customElements,
 * CustomEvent,
 * getComputedStyle,
 * addEventListener?,
 * removeEventListener?,
 * localStorage?,
 * WebKitPlaybackTargetAvailabilityEvent?,
 * window?,
 * document?,
 * chrome?,
 * DocumentFragment?,
 * ResizeObserver?,
 * CastableVideoElement?,
 * navigator?,
 * matchMedia,
 * } }
 * */
export const GlobalThis: (typeof globalThis & {
    WebKitPlaybackTargetAvailabilityEvent?;
    chrome?;
    DocumentFragment?;
    getComputedStyle;
    CastableVideoElement?;
}) | {
    Node;
    HTMLElement;
    customElements;
    CustomEvent;
    getComputedStyle;
    addEventListener?;
    removeEventListener?;
    localStorage?;
    WebKitPlaybackTargetAvailabilityEvent?;
    window?;
    document?;
    chrome?;
    DocumentFragment?;
    ResizeObserver?;
    CastableVideoElement?;
    navigator?;
    matchMedia;
};
/**
 * @type { document & { webkitExitFullscreen? } |
 * {createElement,
 * createElementNS?,
 * activeElement?,
 * fullscreenElement?,
 * webkitExitFullscreen?,
 * getElementById?,
 * pictureInPictureElement?,
 * exitPictureInPicture?,
 * pictureInPictureEnabled?,
 * requestPictureInPicture?,
 * addEventListener?,
 * removeEventListener?,
 * } }
 */
export const Document: (Document & {
    webkitExitFullscreen?;
}) | {
    createElement;
    createElementNS?;
    activeElement?;
    fullscreenElement?;
    webkitExitFullscreen?;
    getElementById?;
    pictureInPictureElement?;
    exitPictureInPicture?;
    pictureInPictureEnabled?;
    requestPictureInPicture?;
    addEventListener?;
    removeEventListener?;
};
declare class Node extends EventTarget {
}
declare class ResizeObserver {
    observe(): void;
    unobserve(): void;
    disconnect(): void;
}
declare class EventTarget {
    addEventListener(): void;
    removeEventListener(): void;
    dispatchEvent(): boolean;
}
export { GlobalThis as globalThis, Document as document };
