import { cwd } from "node:process";
import path from "node:path";
import { pathToFileURL } from "node:url";
import nextConfig from "next/config.js";
import { mkdir, readFile, writeFile } from "node:fs/promises";
const getConfig = nextConfig.default;
const videoConfigDefault = {
  folder: "videos",
  path: "/api/video",
  provider: "mux",
  providerConfig: {},
  loadAsset: async function(assetPath) {
    const file = await readFile(assetPath);
    const asset = JSON.parse(file.toString());
    return asset;
  },
  saveAsset: async function(assetPath, asset) {
    try {
      await mkdir(path.dirname(assetPath), { recursive: true });
      await writeFile(assetPath, JSON.stringify(asset), {
        flag: "wx"
      });
    } catch (err) {
      if (err.code === "EEXIST") {
        return;
      }
      throw err;
    }
  },
  updateAsset: async function(assetPath, asset) {
    await writeFile(assetPath, JSON.stringify(asset));
  }
};
async function getVideoConfig() {
  let nextConfig2 = getConfig();
  if (!nextConfig2?.serverRuntimeConfig?.nextVideo) {
    try {
      nextConfig2 = await importConfig("next.config.js");
    } catch (err) {
      try {
        nextConfig2 = await importConfig("next.config.mjs");
      } catch {
        console.error("Failed to load next-video config.");
      }
    }
  }
  return nextConfig2?.serverRuntimeConfig?.nextVideo;
}
async function importConfig(file) {
  const absFilePath = path.resolve(cwd(), file);
  const fileUrl = pathToFileURL(absFilePath).href;
  const mod = await import(
    /* webpackIgnore: true */
    fileUrl
  );
  const config = mod?.default;
  if (typeof config === "function") {
    return config(process.env.NEXT_PHASE, { defaultConfig: {} });
  }
  return config;
}
export {
  getVideoConfig,
  videoConfigDefault
};
