import React from 'react';
import { type InputMask, type InputMaskElement, type FactoryOpts, type AllFactoryStaticOpts } from 'imask';
type AnyProps = Record<string, unknown>;
export type Falsy = false | 0 | "" | null | undefined;
export type ReactMaskOpts = FactoryOpts & {
    unmask?: 'typed' | boolean;
};
export type UnmaskValue<Opts extends ReactMaskOpts> = Opts['unmask'] extends 'typed' ? InputMask<Opts>['typedValue'] : Opts['unmask'] extends Falsy ? InputMask<Opts>['value'] : InputMask<Opts>['unmaskedValue'];
export type ExtractReactMaskOpts<MaskElement extends InputMaskElement, Props extends IMaskInputProps<MaskElement>> = Extract<Props, ReactMaskOpts>;
export type ReactMaskProps<MaskElement extends InputMaskElement, Props extends IMaskInputProps<MaskElement> = AnyProps> = {
    onAccept?: (value: UnmaskValue<ExtractReactMaskOpts<MaskElement, Props>>, maskRef: InputMask<ExtractMaskOpts<MaskElement, Props>>, e?: InputEvent) => void;
    onComplete?: (value: UnmaskValue<ExtractReactMaskOpts<MaskElement, Props>>, maskRef: InputMask<ExtractMaskOpts<MaskElement, Props>>, e?: InputEvent) => void;
    unmask?: ExtractReactMaskOpts<MaskElement, Props>['unmask'];
    value?: UnmaskValue<ExtractReactMaskOpts<MaskElement, Props>>;
    inputRef?: React.Ref<MaskElement>;
    ref?: React.Ref<React.ComponentType<Props>>;
};
declare const MASK_PROPS: {
    [key in keyof (AllFactoryStaticOpts & ReactMaskProps<InputMaskElement, AllFactoryStaticOpts>)]: any;
};
declare const NON_MASK_OPTIONS_NAMES: readonly ["value", "unmask", "onAccept", "onComplete", "inputRef"];
export type ReactElementProps<MaskElement extends InputMaskElement> = Omit<Omit<React.HTMLProps<MaskElement>, keyof typeof MASK_PROPS>, typeof NON_MASK_OPTIONS_NAMES[number] | 'maxLength'>;
type NonMaskProps<MaskElement extends InputMaskElement, Props extends IMaskMixinProps<MaskElement> = AnyProps> = Omit<Props, keyof FactoryOpts>;
export type ReactMixinComponent<MaskElement extends InputMaskElement, Props extends IMaskMixinProps<MaskElement> = AnyProps> = React.ComponentType<ReactElementProps<MaskElement> & {
    inputRef: React.Ref<MaskElement>;
} & NonMaskProps<MaskElement, Props>>;
export type MaskPropsKeys = Exclude<keyof typeof MASK_PROPS, typeof NON_MASK_OPTIONS_NAMES[number]>;
export type ExtractMaskOpts<MaskElement extends InputMaskElement, Props extends IMaskInputProps<MaskElement>> = Extract<Props, FactoryOpts>;
export type IMaskMixinProps<MaskElement extends InputMaskElement> = Omit<ReactMaskProps<MaskElement>, 'ref'> & FactoryOpts;
export type IMaskInputProps<MaskElement extends InputMaskElement> = ReactElementProps<MaskElement> & IMaskMixinProps<MaskElement>;
export default function IMaskMixin<MaskElement extends InputMaskElement, Props extends IMaskInputProps<MaskElement> = AnyProps>(ComposedComponent: ReactMixinComponent<MaskElement, Props>): React.ForwardRefExoticComponent<React.PropsWithoutRef<Props> & React.RefAttributes<React.ComponentType<Props>>>;
export {};
//# sourceMappingURL=mixin.d.ts.map