"use client";

import React, { useState } from "react";
import Link from "next/link";
import Image from "next/image";
import { useRouter } from "next/navigation";
import Logo from "../../../public/assets/agent-ambition.png";

const options = [
  {
    id: "1",
    heading: "PRESENCE",
    price: "$499",
    label: "NYS 77-Hour Real Estate Pre-Licensing (Instructor-Led)",
    detail:
      "",
    detailPoints: [
      "Engaging, fully approved pre-licensing course that gets you licensed and career-ready.",
      "Instructor-led classes in-person or live via Zoom with active participation.",
      "Complete package: official textbook + exam prep book for confidence from start to exam day.",
    ],
  },
  {
    id: "3",
    heading: "FLEX",
    price: "",
    label:
      "Self-Paced Online Real Estate Licensing (Coming Soon — Join the Waitlist)",
    detail:
      "Our educational solutions were specifically selected to provide you with the highest quality, most-up-to-date content in a flexible format to fit your busy schedule.",
    detailPoints: [
      "Interactive video lessons with quizzes, progress tracking, and immersive learning.",
      "Up-to-date course materials and expert-designed content that keep you aligned with today’s real estate industry standards.",
      "Learn on your schedule, building knowledge and confidence from anywhere",
    ],
  },
  {
    id: "2",
    heading: "NEXTGEN",
    price: "",
    label:
      "Custom Real Estate Education for Schools & Universities (Tailored Solutions for Your School)",
    detail:
      "Flexible, scalable, and customized pre-licensing programs designed to fit your school’s unique needs.",
    detailPoints: [
      "Custom program design aligned to your curriculum and student goals.",
      "Personalized consultation to define scope, structure, and delivery format.",
      "Flexible scheduling and pricing to fit your budget and faculty resources.",
    ],
  },
];

const ComingSoon = () => {
  const [selected, setSelected] = useState("");
  const router = useRouter();

  const handleSelect = (id) => {
    setSelected(id);

    if (id === "1") {
      router.push(`/user-register?plan_id=${id}`);
    } else if (id === "2") {
      window.open("https://calendly.com/jhandlarsky26/nextgen-demo", "_blank");
    }
  };

  return (
    <div className="bg-[#000] w-full min-h-[100vh] coming-soon-page px-3 flex flex-col justify-center">
      <div className="header-logo py-6 max-w-[1200px] lg:px-4 mx-auto relative z-2">
        <Link href="/" className="max-w-[120px] md:max-w-[180px] mx-auto block">
          <Image
            src={Logo}
            alt="Agent Ambition Logo"
            className="max-w-[120px] md:max-w-[180px] mx-auto"
          />
        </Link>
      </div>
      <div>
        <video
          className="mx-auto rounded-3xl relative z-2"
          width="800"
          autoPlay
          controls
          muted
        >
          <source
            src="/assets/Website-Registration-Page-Story.mp4"
            type="video/mp4"
          />
          Your browser does not support the video tag.
        </video>
      </div>
      <div className="py-[40px] max-w-[1200px] lg:px-4 mx-auto relative z-2">
        <div className="flex flex-col gap-2 mb-[25px] sm:mb-[30px] md:mb-[50px]">
          <label className="text-white text-base font-bold text-center">
            Select an Option
          </label>
          <div className="grid grid-cols-1 sm:grid-cols-3 gap-4">
            {options.map((option) => (
              <label
                key={option.id}
                className={`cursor-pointer rounded-lg p-3 text-center flex items-center justify-center flex-col border-[2px] border-[#D8A32B] 
    transition-colors duration-300 ease-in-out 
    hover:bg-[#D8A32B] hover:text-white ${
      selected === option.id ? "bg-[#D8A32B] text-white" : "bg-white text-black"
    } ${option.heading === "FLEX" ? "opacity-50 cursor-not-allowed" : ""}`}
                style={{
                  pointerEvents: option.heading === "FLEX" ? "none" : "auto",
                  // opacity: option.price === "FLEX" ? 0.5 : 1,
                }}
                onClick={() => handleSelect(option.id)}
              >
                <input
                  type="radio"
                  name="plan"
                  value={option.id}
                  checked={selected === option.id}
                  onChange={() => handleSelect(option.id)}
                  className="hidden"
                />
                <div className="text-2xl font-bold">{option?.heading}</div>
                <div className="text-base mt-[7px] font-semibold">
                  {option?.price ? <span>{option?.price}-</span> : ""}
                  {option.label}
                </div>
                <div className="text-sm text-start">{option?.detail}</div>
                <div className="text-sm text-start mt-[7px]">
                  <ul className="list-disc m-auto ps-6">
                    {option.detailPoints.map((point, index) => (
                      <li key={index}>{point}</li>
                    ))}
                  </ul>
                </div>
              </label>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default ComingSoon;
