import { API_END_POINTS } from "@/services/ApiEndpoints";
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

const initialState = {
  courses: null,
  getAllCourseVideo: null
};

export const getAllCourses = createAsyncThunk(
  "getAllCourse/getAllCourses",
  async (_, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(API_END_POINTS.allCourses, {
        headers: {
          Authorization: `Bearer ${token}`,
          method: "GET",
        },
      });
      if (!response.ok) throw new Error("Failed to fetch course progress");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);

export const getAllCoursesVideos = createAsyncThunk(
  "getAllCourses/getAllCoursesVideos",
  async (_, { getState }) => {
    const token = getState().auth?.token;
    try {
      const response = await fetch(`${API_END_POINTS.getCourseVideos}/${_.id}`, {
        method: "GET",
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });
      if (!response.ok) throw new Error("Failed to fetch course videos");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);

const getAllCourseSlice = createSlice({
  name: "getAllCourse",
  initialState,
  reducers: {
    getCourses: (state, action) => {
      state.courses = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder
    .addCase(getAllCourses.fulfilled, (state, action) => {
      state.courses = action.payload;
    })
    .addCase(getAllCoursesVideos.fulfilled, (state, action) => {
      state.getAllCourseVideo = action.payload;
    });
  },
});

export const { getCourses } = getAllCourseSlice.actions;
export default getAllCourseSlice.reducer;
