import { SplitApiSettings } from "./SplitApiSetting";
import { API_END_POINTS } from "./ApiEndpoints";
import { CopyMinus } from "lucide-react";

export const api = SplitApiSettings.injectEndpoints({
  reducerPath: "api",
  refetchOnMountOrArgChange: true,

  endpoints: (builder) => ({
    /////////////////////////////<===MUTATIONS===>//////////////////////

    loginUser: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.loginUser,
          method: "POST",
          body: data,
        };
      },
    }),

    otp: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.otp,
          method: "POST",
          body: data,
        };
      },
    }),

    otpResend: builder.mutation({
      query: () => {
        return {
          url: API_END_POINTS.otpResend,
          method: "GET",
        };
      },
    }),

    logoutUser: builder.mutation({
      query: () => {
        return {
          url: API_END_POINTS.logoutUser,
          method: "POST",
        };
      },
    }),

    courseVideo: builder.mutation({
      query: ({ data, id }) => {
        return {
          url: `${API_END_POINTS.courseVideo}/${id}/logVideoView`,
          method: "PUT",
          body: data,
        };
      },
    }),

    registerUser: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.registerUser,
          method: "POST",
          body: data,
        };
      },
    }),

    updateUserDetail: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.updateUserDetail,
          method: "POST",
          body: data,
        };
      },
    }),

    submitAssignment: builder.mutation({
      query: ({ data, videoId, assignmentId }) => {
        return {
          url: `${API_END_POINTS.submitAssignment}/${videoId}/${assignmentId}/submit`,
          method: "POST",
          body: data,
        };
      },
    }),

    addCoupin: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.addCoupin,
          method: "POST",
          body: data,
        };
      },
    }),

    addSubscription: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.addSubscription,
          method: "POST",
          body: data,
        };
      },
    }),

    delSubscription: builder.mutation({
      query: () => {
        return {
          url: API_END_POINTS.checkSubscription,
          method: "DELETE",
        };
      },
    }),

    notificationAction: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.notifications,
          method: "POST",
          body: data,
        };
      },
    }),
    submitSurvay: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.submitSurvay,
          method: "POST",
          body: data,
        };
      },
    }),
    addCertificate: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.addCertificate,
          method: "POST",
          body: data,
        };
      },
    }),

    downloadCertificate: builder.mutation({
      query: ({ certificateId }) => ({
        url: `${API_END_POINTS.certificateProxy}/${certificateId}`,
        method: "GET",
        responseHandler: (response) => response.blob(), // Important: blob response
      }),
      transformResponse: (response) => response, // Direct blob return
    }),

    /////////////////////////////<===QUERIES===>////////////////////////

    getCourseVideos: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getCourseVideos}/${id}`,
          method: "GET",
        };
      },
    }),

    getCourseVideosById: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getCourseVideosById}/${id}/coursevideo`,
          method: "GET",
        };
      },
    }),

    getComments: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getComments}/${id}/comments`,
          method: "GET",
        };
      },
    }),

    getProfile: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getProfile,
          method: "GET",
        };
      },
    }),

    getCourses: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getCourses,
          method: "GET",
        };
      },
    }),

    getAssignmentById: builder.query({
      query: ({ vid, id }) => {
        return {
          url: `${API_END_POINTS.getAssignmentById}/${vid}/${id}`,
          method: "GET",
        };
      },
    }),

    getAssignmentByCourse: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getAssignmentByCourse,
          method: "GET",
        };
      },
    }),

    getPlans: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getPlans,
          method: "GET",
        };
      },
    }),

    getPaymentIntent: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getPaymentIntent,
          method: "GET",
        };
      },
    }),

    checkSubscription: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.checkSubscription,
          method: "GET",
        };
      },
    }),

    getBlogs: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getBlogs,
          method: "GET",
        };
      },
    }),

    getBlogById: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getBlogs}/${id}`,
          method: "GET",
        };
      },
    }),

    getUserDetail: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getUserDetail,
          method: "GET",
        };
      },
    }),

    getExperience: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getExperience,
          method: "GET",
        };
      },
    }),

    getEducation: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getEducation,
          method: "GET",
        };
      },
    }),

    getNotifications: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.notifications,
          method: "GET",
        };
      },
    }),

    getCategories: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getCategories,
          method: "GET",
        };
      },
    }),

    getDemo: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getCoursess}/${id}/progress`,
          method: "GET",
          headers: {
            Authorization: `Bearer 55|976PRLkGZ5YMo0QB7X5kXDWG61rA3Wr9JAhGclxFe842d5ca`,
          },
        };
      },
    }),

    getCertificates: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getCertificates,
          method: "GET",
        };
      },
    }),
  }),

  overrideExisting: true,
});

export const {
  /////////////////////////////<===WEBSITE MUTATIONS===>//////////////////////
  useRegisterUserMutation,
  useLoginUserMutation,
  useOtpMutation,
  useOtpResendMutation,
  useLogoutUserMutation,
  useCourseVideoMutation,
  useUpdateUserDetailMutation,
  useSubmitAssignmentMutation,
  useAddCoupinMutation,
  useAddSubscriptionMutation,
  useDelSubscriptionMutation,
  useNotificationActionMutation,
  useSubmitSurvayMutation,
  useAddCertificateMutation,
  useDownloadCertificateMutation,
  /////////////////////////////<===WEBSITE QUERIES===>////////////////////////
  useGetCourseVideosQuery,
  useGetCourseVideosByIdQuery,
  useGetCommentsQuery,
  useGetAssignmentByIdQuery,
  useGetAssignmentByCourseQuery,
  useGetPlansQuery,
  useGetPaymentIntentQuery,
  useCheckSubscriptionQuery,
  useGetCoursesQuery,
  useGetBlogsQuery,
  useGetBlogByIdQuery,
  useGetUserDetailQuery,
  useGetExperienceQuery,
  useGetEducationQuery,
  useGetNotificationsQuery,
  useGetCategoriesQuery,
  useGetDemoQuery,
  useGetCertificatesQuery,
} = api;
